/*
 * Parts of this file came from GIPWebViewController
 * googlemac/iPhone/Shared/SuperWebView/GIPSuperWebView.bundle/GIPSuperWebViewInit.js
 */

/**
 * @fileoverview Injecting stubs native code callbacks.
 * The iframe is used to allow buttons to make a request with a URL that iOS can
 * intercept and use to take local action.
 */
(function() {
if (navigator && !navigator.googleInternal) {
  navigator.googleInternal = {
    iframe_: undefined,
    isInitialized: false,
    init: function() {
      if (this.isInitialized) {
        return;
      }
      this.iframe_ = document.createElement('iframe');
      var cssText = 'position:absolute;top:-5000px;height:2px;width:2px;';
      this.iframe_.style.cssText = cssText;
      this.iframe_.src = 'about:blank';
      document.body.appendChild(this.iframe_);
      this.isInitialized = true;
    },
    dispatch: function(object, method, opt_args) {
      var newHash = 'googleapp/api/' + object + '/' + method +
          (opt_args ? '/?' + this.serialize_(opt_args) : '');

      this.init();
      this.iframe_.contentWindow.location.hash = newHash;
      // Setting the hash to an empty string will cause the page to jump to
      // the top of the iframe, which is the top of the window. We instead set
      // it to a dummy value to prevent any jumping form occurring.
      this.iframe_.contentWindow.location.hash = 'null';
    },
    /**
     * Returns a string representation of the passed in object.
     * @param {!Object} args An object to serialize to a string. The keys and
     *     values must all be primitive types and not nested objects / arrays.
     * @return {string} A string representation of the passed in object.
     * @private
     */
    serialize_: function(args) {
      var ret = '';
      for (var i in args) {
        if (args[i] == null || args[i] == undefined) {
          ret += encodeURIComponent(i) + '&';
        } else {
          ret +=
              encodeURIComponent(i) + '=' + encodeURIComponent(args[i]) + '&';
        }
      }
      return ret.substring(0, ret.length - 1);
    },
    /**
     * Returns an object representation of the passed in string. It is
     * expected that this function be used in conjunction with the serialize_
     * function above.
     * @param {string} kvString A string generated by the serialize_ method.
     * @return {!Object} An object representation of the passed in string.
     * @private
     */
    deserialize_: function(kvString) {
      var ret = {};
      var keyValues = kvString.split('&');
      for (var i = 0, l = keyValues.length; i < l; ++i) {
        var kvSplit = keyValues[i].split('=');
        if (kvSplit.length > 1) {
          ret[decodeURIComponent(kvSplit[0])] = decodeURIComponent(kvSplit[1]);
        } else {
          ret[decodeURIComponent(keyValues[i])] = null;
        }
      }
      return ret;
    }
  };

  // The init function requires access to document.body, which is not ready
  // until the load event fires.
  window.addEventListener('load', function() {
    navigator.googleInternal.init();
  }, false);
}
})();



(function() {
if (!window || window.comGoogleAndroidGmsWalletWebviewWebViewComponent ||
    !navigator) {
  return;
}

var messagingApi = {};

messagingApi.completeFlowWithCallbackData = function(data) {
  navigator.googleInternal.dispatch(
      'gwajavascriptnativeinterface',
      'completeFlowWithCallbackData:', {'data': data});
};

messagingApi.completeFlowWithError = function(error) {
  navigator.googleInternal.dispatch(
      'gwajavascriptnativeinterface',
      'completeFlowWithError:', {'error': error});
};

window.comGoogleAndroidGmsWalletWebviewWebViewComponent = messagingApi;
})();
