-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

VERTEX_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
layout(location = 0) in vec4 inPosition;
layout(location = 1) in vec2 inTexCoord0;
out vec2 texCoord0;

void main(void) {
  gl_Position = inPosition;
  texCoord0 = inTexCoord0;
}
]]

FRAGMENT_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
in vec2 texCoord0;
uniform sampler2D texture0;
uniform float float1;
uniform float float2;
uniform float float3;
layout(location = 0) out vec4 outColor;

//
// Box position and size
//

#define numBoxes 6
#define numLayouts 3

//#define AndyWarholPalette
//#define RainbowPastelPalette
//#define RainbowPalette
//#define BlueHuePalette
//#define SunsetPalette
#define BrightPalette

#ifdef AndyWarholPalette
#define numColors 16
vec3 colorPalette[numColors] = vec3[numColors](
  vec3(0.933, 0.106, 0.369),
  vec3(0.839, 0.020, 0.012),
  vec3(0.988, 0.702, 0.639),
  vec3(0.957, 0.667, 0.024),
  
  vec3(0.616, 0.757, 0.816),
  vec3(0.925, 0.871, 0.380),
  vec3(0.890, 0.694, 0.741),
  vec3(0.475, 0.145, 0.086),
  
  vec3(0.776, 0.518, 0.353),
  vec3(0.592, 0.765, 0.686),
  vec3(0.149, 0.522, 0.047),
  vec3(0.945, 0.063, 0.173),
  
  vec3(0.910, 0.475, 0.129),
  vec3(0.957, 0.788, 0.275),
  vec3(0.439, 0.525, 0.675),
  vec3(0.729, 0.827, 0.831)
);
#endif

#ifdef RainbowPastelPalette
#define numColors 6
vec3 colorPalette[numColors] = vec3[numColors](
  vec3(0.922, 0.616, 0.635),
  vec3(0.941, 0.722, 0.518),
  vec3(0.910, 0.902, 0.647),
  vec3(0.733, 0.910, 0.710),
  vec3(0.675, 0.733, 0.910),
  vec3(0.773, 0.675, 0.910)
);
#endif

#ifdef RainbowPalette
#define numColors 6
vec3 colorPalette[numColors] = vec3[numColors](
  vec3(0.949, 0.384, 0.420),
  vec3(0.996, 0.729, 0.310),
  vec3(1.000, 0.918, 0.498),
  vec3(0.537, 0.878, 0.467),
  vec3(0.514, 0.765, 1.000),
  vec3(0.765, 0.506, 0.992)
);
#endif

#ifdef BlueHuePalette
#define numColors 6
vec3 colorPalette[numColors] = vec3[numColors](
  vec3(0.227, 0.255, 0.384),
  vec3(0.200, 0.431, 0.514),
  vec3(1.000, 0.961, 0.816),
  vec3(0.969, 0.808, 0.447),
  vec3(0.969, 0.447, 0.412),
  vec3(0.816, 0.310, 0.271)
);
#endif

#ifdef SunsetPalette
#define numColors 4
vec3 colorPalette[numColors] = vec3[numColors](
  vec3(0.816, 0.282, 0.282),
  vec3(0.953, 0.725, 0.373),
  vec3(0.992, 0.906, 0.404),
  vec3(0.408, 0.584, 0.824)
);
#endif

#ifdef BrightPalette
#define numColors 6
vec3 colorPalette[numColors] = vec3[numColors](
  vec3(0.941, 0.000, 0.000),
  vec3(1.000, 0.490, 0.000),
  vec3(1.000, 0.835, 0.000),
  vec3(0.000, 0.827, 0.000),
  vec3(0.000, 0.478, 0.824),
  vec3(0.459, 0.110, 0.741)
);
#endif

const vec4 boxParams[numBoxes * numLayouts] = vec4[numBoxes * numLayouts](
    vec4( 0.3, -0.625, 0.7, 0.375),
    vec4(-0.7, -0.5, 0.3, 0.5),
    vec4( 0.3, -0.125, 0.7, 0.125),
    vec4(-0.3, 0.625, 0.7, 0.375),
    vec4( 0.7,  0.5, 0.3, 0.5),
    vec4(-0.3,  0.125, 0.7, 0.125),

    vec4( 0.0, -0.8, 1.0, 0.2),
    vec4( 0.0, -0.3, 1.0, 0.3),
    vec4( 0.0,  0.3, 1.0, 0.3),
    vec4( 0.0,  0.8, 1.0, 0.2),
    vec4( 0.0,  0.3, 1.0, 0.3),
    vec4( 0.0,  0.8, 1.0, 0.2),
    
    vec4(-0.2,  0.0, 0.2, 1.0),
    vec4(-0.7,  0.0, 0.3, 1.0),
    vec4( 0.8,  0.0, 0.2, 1.0),
    vec4( 0.3,  0.0, 0.3, 1.0),
    vec4( 0.8,  0.0, 0.2, 1.0),
    vec4( 0.3,  0.0, 0.3, 1.0)
);

//
// Box sdf
//

float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,0.0)) + min(max(d.x,d.y),0.0);
}

//
// Main
//

void main(void)
{
    // Νormalized pixel coordinates
    ivec2 tsi = textureSize(texture0, 0);
    vec2 ts = vec2(float(tsi.x), float(tsi.y));
    vec2 p = (2.0 * gl_FragCoord.xy - ts.xy) / ts.y;
    p.y = -p.y;
    vec2 uv2 = texCoord0;
    float ar = ts.x / ts.y;
    float iTime = float1;
  
    // Box offsets
    vec4 boxOffsets[numBoxes * numLayouts] = vec4[numBoxes * numLayouts](
      vec4( 1.4,  0.0,  ar, 1.0),
      vec4( 0.0, -1.4, 1.0, 1.0),
      vec4( 1.4,  0.0, 1.0, 1.0),
      vec4(-1.4,  0.0,  ar, 1.0),
      vec4( 0.0,  1.4, 1.0, 1.0),
      vec4(-1.4,  0.0,  ar, 1.0),
      
      vec4(-2.0, 0.0, ar, 1.0),
      vec4(2.0, 0.0, ar, 1.0),
      vec4(-2.0, 0.0, ar, 1.0),
      vec4(2.0, 0.0, ar, 1.0),
      vec4(-2.0, 0.0, ar, 1.0),
      vec4(2.0, 0.0, ar, 1.0),
      
      vec4(0.0, -2.0, ar, 1.0),
      vec4(0.0, 2.0, ar, 1.0),
      vec4(0.0, -2.0, ar, 1.0),
      vec4(0.0, 2.0, ar, 1.0),
      vec4(0.0, -2.0, ar, 1.0),
      vec4(0.0, 2.0, ar, 1.0)
    );
  
    // Τime definitions
    float panDuration = 1.0;
    float borderEliminationDuration = 0.5;
    float holdTime = 0.3;
    
    // Box pan timing (start offset, duration)
    vec2 boxTiming[numBoxes * numLayouts] = vec2[numBoxes * numLayouts](
      vec2(0.0               , panDuration      ),
      vec2(-panDuration      , panDuration      ),
      vec2(-panDuration * 2.0, panDuration      ),
      vec2(0.0               , panDuration      ),
      vec2(-panDuration      , panDuration      ),
      vec2(-panDuration * 2.0, panDuration      ),
      
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration)
    );
    
    // Border timing (start offset, duration)
    vec2 borderTiming[numBoxes] = vec2[numBoxes](
      vec2(-7.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-3.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-2.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-2.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-2.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-2.0 * panDuration - holdTime, borderEliminationDuration)
    );
    
    // Pick box layout
    int startIndex = int(float2) * numBoxes;
    
    // Border and rounding
    float borderTimeIn = fract(min(max(iTime + borderTiming[startIndex / numBoxes].x, 0.0), borderTiming[startIndex / numBoxes].y - 1e-6) / borderTiming[startIndex / numBoxes].y);
    //float borderTimeOut = fract(min(max(iTime + borderTiming[startIndex / numBoxes].z, 0.0), borderTiming[startIndex / numBoxes].w - 1e-6) / borderTiming[startIndex / numBoxes].w);
    //float borderTime = min(borderTimeIn, borderTimeOut);
    float rounding = 0.1 * (borderEliminationDuration - borderTimeIn);
    float padding = 0.0025 * (borderEliminationDuration - borderTimeIn);

    // Boxes
    float d = 1e1;
    int boxId = 0;
    for (int i = startIndex; i < startIndex + 6; i++) {
      float time = fract(min(max(iTime + boxTiming[i].x, 0.0), boxTiming[i].y - 1e-6) / boxTiming[i].y);
      vec4 bp = boxParams[i];
      vec4 bo = boxOffsets[i];
      vec2 p = p + bp.xy * vec2(ar, 1.0) + bo.xy * bo.zw * (1.0 - time);
      vec2 v = bp.zw * vec2(ar, 1.0) - rounding - padding;
      float distance = sdBox(p, v) - rounding;

      // Union of shapes
      if (distance < d) {
        d = distance;
        boxId = i - startIndex;
      }
    }
    
    vec3 col = (vec3(1.0) - sign(d));
    
    // Smoothing
    col *= 1.0 - exp(-512.0 * abs(d));
    col = min(col, vec3(1.0));

    // Color the boxes
    vec3 gammaColor = texture(texture0, uv2).rgb;
    float gray = dot(gammaColor, vec3(0.2126, 0.7152, 0.0722));
    
    float colDuration = 4.0;
    float colMixDuration = 1.0;
    float time6 = fract(min(max(iTime -3.0 * panDuration, 0.0), colDuration - 1e-6) / colDuration);
    float time7 = fract(min(max(iTime -8.0, 0.0), colMixDuration - 1e-6) / colMixDuration);
    int colIndex = int(time6 * 12.0);
    
    if (boxId == 0) {
      col *= mix(gray * colorPalette[(colIndex) % numColors], gammaColor, time7);
    }
    else if (boxId == 1) {
      col *= mix(gray * colorPalette[(colIndex + 1) % numColors], gammaColor, time7);
    }
    else if (boxId == 2) {
      col *= mix(gray * colorPalette[(colIndex + 2) % numColors], gammaColor, time7);
    }
    else if (boxId == 3) {
      col *= mix(gray * colorPalette[(colIndex + 3) % numColors], gammaColor, time7);
    }
    else if (boxId == 4) {
      col *= mix(gray * colorPalette[(colIndex + 4) % numColors], gammaColor, time7);
    }
    else if (boxId == 5) {
      col *= mix(gray * colorPalette[(colIndex + 5) % numColors], gammaColor, time7);
    }

    outColor = vec4(col, 1.0);
}
]]


---- Lua code ----

EFFECT = [[
    {
      "start_amount": 0.0,
      "end_amount": 0.0,
      "curve": "LINEAR"
    }
  ]];

CURVES = [[
    {
      "float1": [{"timestamp": 0.0, "value": 0.0, "curve": "LINEAR"},
                 {"timestamp": 12.0, "value": 12.0, "curve": "EASE_IN"}],
      "float2": [{"timestamp": 0.0, "value": 0.0, "curve": "CONSTANT"},
                 {"timestamp": 12.0, "value": 0.0, "curve": "CONSTANT"}],
      "float3": [{"timestamp": 0.0, "value": 0.0, "curve": "CONSTANT"},
                 {"timestamp": 12.0, "value": 0.0, "curve": "CONSTANT"}]
    }
  ]];

function addClip(clipDuration, mediaIndex)
  local mediaItem = MediaItems[mediaIndex]
  local startTime = mediaItem:getStartSec()
  local speed = 1.0
  Project:addClip(startTime, clipDuration, speed, mediaItem)
end

-- Variable to keep track of clip start times
local absoluteStartTime = 0.0

function main()
  local numMediaItems = #MediaItems
  local suggestedClipDuration = 8
  local maxTimelineDuration = 30

  for i = 1, numMediaItems, 1 do
    local clipDuration = suggestedClipDuration

    -- Sanity checks for clip durations if input is video
    local mediaItem = MediaItems[i]
    if (mediaItem:isVideo()) then
        local mediaDuration = mediaItem:getDurationSec()
        -- Allow full video duration if it's less that maximum allowed
        if (absoluteStartTime + mediaDuration <= maxTimelineDuration) then
            clipDuration = mediaDuration
        else
        -- Otherwise trim to fit
            clipDuration = maxTimelineDuration - absoluteStartTime
        end
    end

    -- Add clip
    addClip(clipDuration, i)

    -- Cropping to rationalize texture coords
    Treatments:zoomTreatment(absoluteStartTime, absoluteStartTime + clipDuration, EFFECT)

    -- Add heart effect
    ShaderEffects:addShader(VERTEX_SHADER, FRAGMENT_SHADER, 0, clipDuration, CURVES)

    -- Keep track of absolute start time of next clip
    absoluteStartTime = absoluteStartTime + clipDuration
  end
end

main()
