-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

-- Get the median of a table.
function table.median( t )
  local temp={}

  -- deep copy table so that when we sort it, the original is unchanged
  -- also weed out any non numbers
  for k,v in pairs(t) do
    if type(v) == 'number' then
      table.insert( temp, v )
    end
  end

  table.sort( temp )

  -- If we have an even number of table elements or odd.
  if math.fmod(#temp,2) == 0 then
    -- return mean value of middle two elements
    return ( temp[#temp/2] + temp[(#temp/2)+1] ) / 2
  else
    -- return middle element
    return temp[math.ceil(#temp/2)]
  end
end

function table.contains(table, element)
  for _, value in pairs(table) do
      if value == element then
          return true
      end
  end
  return false
end

function getConfig()
  -- default config
  local config = {
      maxItemCount = 15,
      isVideoSegmentationEnabled = false,
      minVideoSegmentDuration = 30,
      seedValue = 0,
      shouldAllowDuplicatedMedia = true,
      shouldEnableSingleMediaLogic = false
  }

  for _, mediaEvent in ipairs(MediaEvents) do
      if mediaEvent:getSourceMedia() == "config" then
      for i = 0, mediaEvent:size() - 1, 1 do
          local startTime, weight, duration, tags = mediaEvent:getEvent(i)
          local param = tags[1]
          if param == "maxItemCount" then
            config.maxItemCount = math.floor(weight)
          elseif param == "isVideoSegmentationEnabled" then
            config.isVideoSegmentationEnabled = weight == 1.0
          elseif param == "minVideoSegmentDuration" then
            config.minVideoSegmentDuration = math.floor(weight)
          elseif param == "seed" then
            config.seedValue = math.floor(weight)
          elseif param == "shouldAllowDuplicatedMedia" then
            config.shouldAllowDuplicatedMedia = param
          elseif param == "shouldEnableSingleMediaLogic" then
            config.shouldEnableSingleMediaLogic = weight == 1.0
          end
      end
      end
  end

  return config
end

GT_PARAMS = [[
  {
    "start_zoom": 1.2,
    "mid_zoom": 1.0,
    "end_zoom": 1.3,
    "mid_point": 0.75,
    "start_angle": 0.3,
    "mid_angle":0.0,
    "end_angle": -0.1,
    "global": true,
    "start_curve": "EASE_OUT_SINE",
    "end_curve": "EASE_IN_CUBIC",
    "clear_background": true
  }
]];

GT_PARAMS_1 = [[
  {
    "start_zoom": 1.5,
    "mid_zoom": 1.0,
    "end_zoom": 1.0,
    "mid_point": 0.6,
    "start_angle": 0.1,
    "mid_angle":0.0,
    "end_angle": -0.3,
    "global": true,
    "start_curve": "EASE_OUT_CIRC",
    "end_curve": "EASE_IN_CIRC",
    "clear_background": true
  }
]];

GT_PARAMS_2 = [[
  {
    "start_zoom": 1.4,
    "mid_zoom": 1.0,
    "end_zoom": 1.2,
    "mid_point": 0.7,
    "start_angle": 0.2,
    "mid_angle":0.0,
    "end_angle": -0.3,
    "global": true,
    "start_curve": "EASE_OUT_CIRC",
    "end_curve": "EASE_IN_CIRC",
    "clear_background": true
  }
]];

GT_PARAMS_3 = [[
  {
    "start_zoom": 1.4,
    "mid_zoom": 1.0,
    "end_zoom": 1.3,
    "mid_point": 0.65,
    "start_angle": 0.1,
    "mid_angle":0.0,
    "end_angle": -0.4,
    "global": true,
    "start_curve": "EASE_OUT_CIRC",
    "end_curve": "EASE_IN_CIRC",
    "clear_background": true
  }
]];

T_PARAMS = [[
  {
    "start_zoom": 1.1,
    "mid_zoom": 1.0,
    "end_zoom": 1.2,
    "mid_point": 0.5,
    "start_angle": 0.2,
    "mid_angle":0.0,
    "end_angle": -0.4,
    "global": false,
    "start_curve": "EASE_OUT",
    "end_curve": "EASE_IN",
    "clear_background": true
  }
]];

T_PARAMS_1 = [[
  {
    "start_zoom": 1.0,
    "mid_zoom": 1.0,
    "end_zoom": 1.4,
    "mid_point": 0.55,
    "start_angle": 0.1,
    "mid_angle":0.0,
    "end_angle": -0.1,
    "global": false,
    "start_curve": "EASE_OUT",
    "end_curve": "EASE_IN_CUBIC",
    "clear_background": true
  }
]];

T_PARAMS_2 = [[
  {
    "start_zoom": 1.5,
    "mid_zoom": 1.0,
    "end_zoom": 1.0,
    "mid_point": 0.6,
    "start_angle": 0.1,
    "mid_angle":0.0,
    "end_angle": 0.0,
    "global": false,
    "start_curve": "EASE_OUT_EXPO",
    "end_curve": "EASE_IN_CIRC",
    "clear_background": true
  }
]];

T_PARAMS_3 = [[
  {
    "start_zoom": 1.2,
    "mid_zoom": 1.0,
    "end_zoom": 1.3,
    "mid_point": 0.6,
    "start_angle": 0.4,
    "mid_angle":0.0,
    "end_angle": -0.1,
    "global": false,
    "start_curve": "EASE_OUT_CIRC",
    "end_curve": "EASE_IN_CIRC",
    "clear_background": true
  }
]];

T_PARAMS_4 = [[
  {
    "start_zoom": 1.2,
    "mid_zoom": 1.1,
    "end_zoom": 1.0,
    "mid_point": 0.5,
    "start_angle": 0.4,
    "mid_angle":0.2,
    "end_angle": 0.0,
    "global": false,
    "start_curve": "LINEAR",
    "end_curve": "LINEAR",
    "clear_background": true
  }
]];

WHITE_PARAMS = [[
{
  "curve": "LINEAR",
  "start_amount": 0.4,
  "end_amount": 0.0
}
]];

function addClip(suggestedDuration, mediaIndex)
  if (mediaIndex <= #MediaItems) then
    local mediaItem = MediaItems[mediaIndex]
    local mediaStartTime = mediaItem:getStartSec()
    local speed = 1.0

    local duration = suggestedDuration
    if (mediaItem:isVideo()) then
      local mediaDuration = mediaItem:getDurationSec()
      if (mediaDuration < suggestedDuration) then
        duration = mediaDuration
      end
    end

    Project:addClip(mediaStartTime, duration, 1.0, mediaItem)
  end
end

function getBeatInfo()
  local beatsTable = {}
  local prevStart = 0
  local beatDurations = {}
  local medianDuration = -1
  for _, mediaEvent in ipairs(MediaEvents) do
      if mediaEvent:getSourceMedia() == "config" then goto CONTINUE end
      local numEvents = mediaEvent:size()
      local onsetsAfter = 0
      for i = 0, numEvents - 1, 1 do
      -- check 'beat' tag in an event
      local start, weights, _, tags = mediaEvent:getEvent(i)
      if (table.contains(tags, "beat") and table.contains(tags, "onset") ) then
          -- save previous beat's onsets after the beat
          if #beatsTable ~= 0 then
              beatsTable[#beatsTable].onsetsAfter = onsetsAfter
          end
          -- save the new beat
          local beat = {
              startTime = start,
              weight = weights,
              onset = table.contains(tags, "onset"),
              onsetsBefore = onsetsAfter, -- onsets before beat are previous beat's onsets after the beat
              onsetsAfter = 0, -- This will be updated by the next beat.
          }
          table.insert(beatsTable, beat)
          onsetsAfter = 0
          -- save the beat duration
          local currDuration = start - prevStart
          table.insert(beatDurations, currDuration)
          prevStart = start
      else
          if #beatsTable ~= 0 then
              onsetsAfter = onsetsAfter + 1
          end
      end
      end
      ::CONTINUE::
  end
  if #beatDurations > 1 then
      medianDuration = table.median(beatDurations)
  end
  return beatsTable, medianDuration
end

function dayAndNight(shouldRepeatMedia)
  local totalClips = #MediaItems
  if shouldRepeatMedia then
    totalClips = 15
  end

  local numMediaItems = #MediaItems
  local suggestedClipDuration = 3 * 0.348 -- represents the beatduration of the song that this template designed for
  local maxTimelineDuration = suggestedClipDuration * numMediaItems

  -- Find beatDuration
  local _, beatDuration = getBeatInfo()
  if (beatDuration > 0.0 and suggestedClipDuration > beatDuration) then
    local beatsCount = math.floor(suggestedClipDuration/beatDuration)
    suggestedClipDuration = beatsCount * beatDuration
  end

  local part1Clips = 6
  local idx = 1

  for i = 1,6 do
    local duration = suggestedClipDuration
    addClip(duration, idx)

    if (i == 3) then
      Treatments:transformTreatment(0.0, duration, T_PARAMS_1)
      Treatments:whiteTreatment(0.0, duration, WHITE_PARAMS)
    end

    idx = idx + 1
    if (idx > #MediaItems) then
      if shouldRepeatMedia then
        idx = 1
      else
        break
      end
    end
  end

  for i = 1, totalClips - part1Clips do
    local duration = suggestedClipDuration
    if (i == 1) then
      addClip(duration, idx)
      Treatments:transformTreatment(0.0, duration, T_PARAMS)
    elseif (i <= 5) then
      addClip(duration, idx)
      Treatments:transformTreatment(0.0, duration, T_PARAMS)
    else
      addClip(duration, idx)

      if (i == 6) then
        Treatments:transformTreatment(0.0, duration, T_PARAMS_2)
      end
      if (i == 7) then
        Treatments:transformTreatment(0.0, duration, T_PARAMS_3)
      end
      if (i == 9) then
        Treatments:whiteTreatment(0.0, duration, WHITE_PARAMS)
      end
      if (i == 10) then
        Treatments:transformTreatment(0.0, duration, T_PARAMS_4)
      end
    end

    idx = idx + 1
    if (idx > #MediaItems) then
      if shouldRepeatMedia then
        idx = 1
      else
        break
      end
    end
  end

  -- Add global treatments
  Treatments:transformTreatment(0.0, 2*suggestedClipDuration, GT_PARAMS_1); -- applied to the 1-2 clips
  Treatments:transformTreatment(4*suggestedClipDuration, 6*suggestedClipDuration, GT_PARAMS_2); -- applied to 4-6 clips
end

function dayAndNightSingleMedia()
  local suggestedTransitionTime = 3 * 0.348 -- represents the beatduration of the song that this template designed for

  -- Find beatDuration
  local _, beatDuration = getBeatInfo()
  if (beatDuration > 0.0 and suggestedTransitionTime > beatDuration) then
      local beatsCount = math.floor(suggestedTransitionTime/beatDuration)
      suggestedTransitionTime = beatsCount * beatDuration
  end

  local timelineDuration = 8 * suggestedTransitionTime

  addClip(timelineDuration, 1)

  local CLIP_TRANSFORM_PARAMS = [[
    {
      "start_zoom": 1.4,
      "mid_zoom": 1.0,
      "end_zoom": 1.2,
      "mid_point": 0.7,
      "start_angle": -0.3,
      "mid_angle":0.0,
      "end_angle": 0.2,
      "global": false,
      "start_curve": "EASE_OUT_CIRC",
      "end_curve": "EASE_IN_CIRC",
      "clear_background": true
    }
  ]]
  -- clip 3
  Treatments:transformTreatment(3 * suggestedTransitionTime, 3 * suggestedTransitionTime + suggestedTransitionTime, CLIP_TRANSFORM_PARAMS)
  Treatments:whiteTreatment(3 * suggestedTransitionTime, 3 * suggestedTransitionTime + suggestedTransitionTime, WHITE_PARAMS)

  -- clip 7
  local part2Clips = 7
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, CLIP_TRANSFORM_PARAMS)
  part2Clips = 8
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, T_PARAMS)
  part2Clips = 9
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, T_PARAMS)
  part2Clips = 10
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, T_PARAMS)
  part2Clips = 11
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, T_PARAMS)
  part2Clips = 12
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, T_PARAMS_2)
  part2Clips = 13
  Treatments:transformTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, T_PARAMS_3)
  part2Clips = 15
  Treatments:whiteTreatment(part2Clips * suggestedTransitionTime, part2Clips * suggestedTransitionTime + suggestedTransitionTime, WHITE_PARAMS)

  -- Add global treatments
  Treatments:transformTreatment(0.0, 3*suggestedTransitionTime, GT_PARAMS_1); -- applied to the 1-3 clips
  Treatments:transformTreatment(4*suggestedTransitionTime, 7*suggestedTransitionTime, GT_PARAMS_2); -- applied to 4-7 clips
end

local config = getConfig()
if (#MediaItems == 1 and config.shouldEnableSingleMediaLogic) then
  dayAndNightSingleMedia()
else
  dayAndNight(false)
end
