-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

VERTEX_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
layout(location = 0) in vec4 inPosition;
layout(location = 1) in vec2 inTexCoord0;
out vec2 texCoord0;

void main(void) {
  gl_Position = inPosition;
  texCoord0 = inTexCoord0;
}
]]

FRAGMENT_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
in vec2 texCoord0;
uniform sampler2D texture0;
uniform float float1;
uniform float float2;
uniform float float3;
uniform vec2 viewport;
layout(location = 0) out vec4 outColor;

float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,0.0)) + min(max(d.x,d.y),0.0);
}

float sdCircle( vec2 p, float r )
{
    return length(p) - r;
}

void main(void)
{
    // Νormalized pixel coordinates
    ivec2 tsi = textureSize(texture0, 0);
    vec2 ts = vec2(float(tsi.x), float(tsi.y));
    vec2 p = (2.0 * gl_FragCoord.xy - ts.xy) / ts.y;
    p.y = -p.y;
    float ar = ts.x / ts.y;
    vec2 p2 = p + vec2(-0.15, 0.0);

    // Size
    vec2 boxHalfSize = vec2(0.15, 0.15);

    // Domain repetition
    vec2 s = boxHalfSize * 2.0;
    vec2 rc = round(p2/s);
    vec2 sp = s*rc;
    vec2 q = p2 - sp;

    // Time
    const float transitionDuration = 0.25;
    float rowSize = ar / boxHalfSize.x;
    float rSign = -sign(mod(rc.y, 2.0) - 0.5);
    float boxIndex = rSign * sp.x + (rowSize) + ((-sp.y) * rowSize);
    float time = fract(min(max(float1 - boxIndex * transitionDuration, 0.0), transitionDuration - 1e-6) / transitionDuration);

    // Box sdf
    vec2 v1 = boxHalfSize * time - vec2(1.0, 1.0) * 0.01;
    float d = sdBox(q, v1);

    // Circle sdf - fill for padding
    const float transitionDuration2 = 0.8;
    float time2 = fract(min(max(float1 - 20.0 * transitionDuration, 0.0), transitionDuration2 - 1e-6) / transitionDuration2);
    float d2 = sdCircle(p, 2.0 * time2);

    // Color sampling
    vec3 gammaColor = texture(texture0, texCoord0).rgb;

    // Box color
    vec3 col = (vec3(1.0) - sign(d));
    col = min(col, vec3(1.0));
    col *= gammaColor;

    // Padding color
    vec3 col2 = (abs(0.1 / min(-d2, 0.0))) * vec3(0.6, 0.8, 1.0) * 1.0;
    col2 = min(col2, vec3(1.0));
    col2 = mix(col2, col2 * gammaColor, float(col2.b >= 1.0));

    col = mix(col, col2, float(sign(d) == 1.0 && time2 > 0.0));

  outColor = vec4(col, 1.0);
}
]]


---- Lua code ----

-- Helper functions to construct animation curves
function makeKeyframe(timestamp, value, curve)
    return [[{"timestamp": ]] .. tostring(timestamp) .. [[, "value": ]] .. tostring(value) .. [[, "curve": "]] .. curve .. [["}]]
end

function makeJSONAnimationCurve(uniformName, animationCurve)
    return [["]] .. uniformName .. [[": []] .. animationCurve .. "]"
end

function makeJSONCurves(curve1, curve2, curve3)
    return [[{]] .. curve1 .. "," .. curve2 .. "," .. curve3 .. [[}]]
end

function addClip(clipDuration, mediaIndex)
  local mediaItem = MediaItems[mediaIndex]
  local startTime = mediaItem:getStartSec()
  local speed = 1.0
  Project:addClip(startTime, clipDuration, speed, mediaItem)
end

-- Variable to keep track of clip start times
local absoluteStartTime = 0.0

function main()
  local numMediaItems = #MediaItems
  local suggestedClipDuration = 8
  local maxTimelineDuration = 30

  for i = 1, numMediaItems, 1 do
    local clipDuration = suggestedClipDuration

    -- Sanity checks for clip durations if input is video
    local mediaItem = MediaItems[i]
    if (mediaItem:isVideo()) then
        local mediaDuration = mediaItem:getDurationSec()
        -- Allow full video duration if it's less that maximum allowed
        if (absoluteStartTime + mediaDuration <= maxTimelineDuration) then
            clipDuration = mediaDuration
        else
        -- Otherwise trim to fit
            clipDuration = maxTimelineDuration - absoluteStartTime
        end
    end

    -- Add clip
    addClip(clipDuration, i)

    -- Prepare animation curves
    local float1 = makeKeyframe(0.0, 0.0, "LINEAR")
    float1 = float1 .. "," .. makeKeyframe(clipDuration, clipDuration, "LINEAR")
    float1 = makeJSONAnimationCurve("float1", float1)

    local float2 = makeKeyframe(0.0, 0.0, "LINEAR")
    float2 = float2 .. "," .. makeKeyframe(0.0, 0.0, "LINEAR")
    float2 = makeJSONAnimationCurve("float2", float2)

    local float3 = makeKeyframe(0.0, 0.0, "LINEAR")
    float3 = float3 .. "," .. makeKeyframe(0.0, 0.0, "LINEAR")
    float3 = makeJSONAnimationCurve("float3", float3)

    local curves = makeJSONCurves(float1, float2, float3)

    -- Add grid reveal effect
    ShaderEffects:addShader(VERTEX_SHADER, FRAGMENT_SHADER, absoluteStartTime, absoluteStartTime + clipDuration, curves)

    -- Keep track of absolute start time of next clip
    absoluteStartTime = absoluteStartTime + clipDuration
  end
end

main()
