-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

VERTEX_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
layout(location = 0) in vec4 inPosition;
layout(location = 1) in vec2 inTexCoord0;
out vec2 texCoord0;

void main(void) {
  gl_Position = inPosition;
  texCoord0 = inTexCoord0;
}
]]

FRAGMENT_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
in vec2 texCoord0;
uniform sampler2D texture0;
uniform float float1;
uniform float float2;
uniform float float3;
layout(location = 0) out vec4 outColor;

#define t (float1)

//
// Pseudo random number generator
//

vec2 hash22(vec2 p)
{
    return fract(sin(vec2(dot(p,vec2(65.1375,23.7513)),dot(p,vec2(37.97844, 17.9753))))*47354.71168);
}

//
// Hearts Signed Distance Function
//

float sdHeart(vec2 p, float s)
{
    #define dot2(x) dot(x, x)
    p.y += s * 0.5833333;
    p.x = abs(p.x);
    if (p.y + p.x > s) return sqrt(dot2(p - vec2(0.25, 0.75) * s)) - s * sqrt(2.0) / 4.0;
    return sqrt(min(dot2(p - vec2(0.0, s)), dot2(p - 0.5 * max(p.y + p.x, 0.0)))) * sign(p.x - p.y);
}

//
// Get distance for all sdf hearts
//

float voronoihearts(vec2 uv, vec2 suv)
{
    #define scale 0.15
    float md = 1e1;

    // Scale affects number of drawn sdf hearts on screen
    vec2 i = floor(uv / scale);

    // Mod adds copies of sdf shapes
    vec2 p = mod(uv, scale);

    for(int x = -1; x <= 1; x++)
    {
        for(int y = -1; y <= 1; y++)
        {
            // Get a psudo-random number
            vec2 ro = hash22((i + vec2(float(x), float(y))) * scale);
            float rnd = ro.x + ro.y;

            // Get distance for each sdf heart
            vec2 rp = p - ((sin(ro * 7.0 + t * 0.3) * 0.5 + 0.5) + vec2(x, y)) * scale;
            rp.x *= 4.0 + sin(0.5 + sin(6.0 * (t+rnd))) * 0.03;
            rp.y *= 4.0 + sin(1.5 + sin(3.0 * (t+rnd))) * 0.1;
            float d = sdHeart(rp, (0.08 + rnd * 0.08) * clamp(suv.y + 0.7, 0.0, 1.0));

            // Expression md > 0.01 accounts for overlap between hearts
            // Expression d < md accounts for taking the union of shapes
            if (md > 0.01 && d < md) md = d;
        }
    }
    #undef scale
    return md;
}

//
// Main
//

void main(void)
{
    ivec2 tsi = textureSize(texture0, 0);
    vec2 ts = vec2(float(tsi.x), float(tsi.y));
    vec2 uv = (texCoord0 * ts - .5*ts.xy) / ts.y;
    vec2 uv2 = texCoord0;
    uv.y = -uv.y;
    uv.y -= t * 0.1;

    float d = voronoihearts(uv, uv2);
    vec3 col = (abs(0.01 / min(-d, 0.0))) * vec3(0.9, 0.2, 0.15);
    vec3 texCol = texture(texture0, uv2).rgb;
    col = clamp(col, 0.0, 1.0);
    col = mix(col, col + texCol, step(0.01, d));
    col = clamp(col, 0.0, 1.0);

    outColor = vec4(col, 1);
}
]]


---- Lua code ----

-- Helper functions to construct animation curves
function makeKeyframe(timestamp, value, curve)
    return [[{"timestamp": ]] .. tostring(timestamp) .. [[, "value": ]] .. tostring(value) .. [[, "curve": "]] .. curve .. [["}]]
end

function makeJSONAnimationCurve(uniformName, animationCurve)
    return [["]] .. uniformName .. [[": []] .. animationCurve .. "]"
end

function makeJSONCurves(curve1, curve2, curve3)
    return [[{]] .. curve1 .. "," .. curve2 .. "," .. curve3 .. [[}]]
end

function addClip(clipDuration, mediaIndex)
  local mediaItem = MediaItems[mediaIndex]
  local startTime = mediaItem:getStartSec()
  local speed = 1.0
  Project:addClip(startTime, clipDuration, speed, mediaItem)
end

-- Variable to keep track of clip start times
local absoluteStartTime = 0.0

function main()
  local numMediaItems = #MediaItems
  local suggestedClipDuration = 8
  local maxTimelineDuration = 30

  for i = 1, numMediaItems, 1 do
    local clipDuration = suggestedClipDuration

    -- Sanity checks for clip durations if input is video
    local mediaItem = MediaItems[i]
    if (mediaItem:isVideo()) then
        local mediaDuration = mediaItem:getDurationSec()
        -- Allow full video duration if it's less that maximum allowed
        if (absoluteStartTime + mediaDuration <= maxTimelineDuration) then
            clipDuration = mediaDuration
        else
        -- Otherwise trim to fit
            clipDuration = maxTimelineDuration - absoluteStartTime
        end
    end

    -- Add clip
    addClip(clipDuration, i)

    -- Prepare animation curves
    local float1 = makeKeyframe(0.0, absoluteStartTime, "LINEAR")
    float1 = float1 .. "," .. makeKeyframe(clipDuration, absoluteStartTime + clipDuration, "LINEAR")
    float1 = makeJSONAnimationCurve("float1", float1)

    local float2 = makeKeyframe(0.0, 0.0, "LINEAR")
    float2 = float2 .. "," .. makeKeyframe(0.0, 0.0, "LINEAR")
    float2 = makeJSONAnimationCurve("float2", float2)

    local float3 = makeKeyframe(0.0, 0.0, "LINEAR")
    float3 = float3 .. "," .. makeKeyframe(0.0, 0.0, "LINEAR")
    float3 = makeJSONAnimationCurve("float3", float3)

    local curves = makeJSONCurves(float1, float2, float3)

    -- Add heart effect
    ShaderEffects:addShader(VERTEX_SHADER, FRAGMENT_SHADER, absoluteStartTime, absoluteStartTime + clipDuration, curves)

    -- Keep track of absolute start time of next clip
    absoluteStartTime = absoluteStartTime + clipDuration
  end
end

main()
