-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

T_PARAMS_1 = [[
  {
    "start_zoom": 1.0,
    "mid_zoom": 1.07,
    "end_zoom": 1.14,
    "mid_point": 0.5,
    "start_angle": 0.0,
    "mid_angle": 0.0,
    "end_angle": 0.0,
    "global": false,
    "start_curve": "LINEAR",
    "end_curve": "LINEAR"
  }
]];

T_PARAMSLEFT = [[
  {
    "start_zoom": 1.6,
    "mid_zoom": 1.6,
    "end_zoom": 1.6,
    "mid_point": 0.5,
    "start_angle": 0.2,
    "mid_angle":0.2,
    "end_angle": 0.2,
    "global": false,
    "start_curve": "LINEAR",
    "end_curve": "LINEAR"
  }
]];

T_PARAMSRIGHT = [[
  {
    "start_zoom": 1.4,
    "mid_zoom": 1.4,
    "end_zoom": 1.4,
    "mid_point": 0.5,
    "start_angle": -0.2,
    "mid_angle": -0.2,
    "end_angle": -0.2,
    "global": false,
    "start_curve": "LINEAR",
    "end_curve": "LINEAR"
  }
]];

T_PARAMSOUTRO = [[
  {
    "start_zoom": 1.6,
    "mid_zoom": 1.3,
    "end_zoom": 1.0,
    "mid_point": 0.5,
    "start_angle": 0.15,
    "mid_angle": 0.07,
    "end_angle": 0.0,
    "global": false,
    "start_curve": "LINEAR",
    "end_curve": "LINEAR"
  }
]];

WHITE_PARAMS_1 = [[
  {
    "end_amount": 0.9,
    "curve": "STEP"
  }
]]

WHITE_PARAMS_2 = [[
  {
    "end_amount": 0.5,
    "curve": "STEP"
  }
]]

WHITE_PARAMS_3 = [[
  {
    "end_amount": 0.1,
    "curve": "STEP"
  }
]]


WHITE_PARAMS_TR = [[
  {
    "end_amount": 0.5,
    "curve": "TRIANGLE"
  }
]]


SATURATION = [[
  {
    "brightness": 0.0,
    "contrast": 1.0,
    "saturation": 0.0
  }
]];



SATURATION2 = [[
  {
    "brightness": 0.0,
    "contrast": 1.3,
    "saturation": 0.5
  }
]];

SEPIA = [[
  {
    "darken": 0.2,
    "sepia_amount": 0.0
  }
]]

TINT = [[
  {
    "intensity": 0.3,
    "r": 0.75,
    "g": 0.75,
    "b": 0.1
  }
]]

-- -----------------------
VERTEX_SHADER_SATURATION_TINT_SEPIA = [[
precision highp float; // fill 1st line to help auto-indent
layout(location = 0) in vec4 inPosition;
layout(location = 1) in vec2 inTexCoord0;
out vec2 texCoord0;

void main(void) {
  gl_Position = inPosition;
  texCoord0 = inTexCoord0;
}
]]

FRAGMENT_SHADER_SATURATION_TINT_SEPIA = [[
precision highp float; // fill 1st line to help auto-indent
in vec2 texCoord0;
uniform sampler2D texture0;
uniform float float1; // time animation
layout(location = 0) out vec4 outColor;

mat4 brightnessMatrix(float brightness) {
  return mat4(
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      brightness,
      brightness,
      brightness,
      1);
}

mat4 contrastMatrix(float contrast) {
  float t = (1.0 - contrast) / 2.0;

  return mat4(
      contrast,
      0,
      0,
      0,
      0,
      contrast,
      0,
      0,
      0,
      0,
      contrast,
      0,
      t,
      t,
      t,
      1);
}

mat4 saturationMatrix(float saturation) {
  vec3 luminance = vec3(0.3086, 0.6094, 0.0820);

  float oneMinusSat = 1.0 - saturation;

  vec3 red = vec3(luminance.x * oneMinusSat);
  red += vec3(saturation, 0, 0);

  vec3 green = vec3(luminance.y * oneMinusSat);
  green += vec3(0, saturation, 0);

  vec3 blue = vec3(luminance.z * oneMinusSat);
  blue += vec3(0, 0, saturation);

  return mat4(red, 0, green, 0, blue, 0, 0, 0, 0, 1);
}

vec3 tintVector(vec3 tintColor, float intensity) {
  return vec3(tintColor.x * intensity, tintColor.y * intensity, tintColor.z * intensity);
}

void main(void) {
  vec4 col = texture(texture0, texCoord0);
  vec4 color = col;

    if (float1 >= 0.5 && float1 < 0.75)
    {
      const float brightness = 0.0;
      const float contrast = 1.0;
      const float saturation = 0.0;

      // saturation
      color = brightnessMatrix(brightness) * contrastMatrix(contrast) * saturationMatrix(saturation) * color;
    }
    else if (float1 >= 0.75 && float1 < 1.0)
    {
      const float brightness = 0.0;
      const float contrast = 1.3;
      const float saturation = 0.5;
      const float darken = 0.2;
      const float sepiaAmount = 0.0;

      // saturation
      color = brightnessMatrix(brightness) * contrastMatrix(contrast) * saturationMatrix(saturation) * color;

      // tint
      float r = color.r;
      float g = color.g;
      float b = color.b;

      r += 0.75 * 0.3;
      g += 0.75 * 0.3;
      b += 0.1 * 0.3;

      // sepia
      color.r =
          min(1.0,
              (r * (1.0 - (0.607 * sepiaAmount))) +
                  (g * (0.769 * sepiaAmount)) + (b * (0.189 * sepiaAmount)));
      color.g = min(
          1.0,
          (r * 0.349 * sepiaAmount) + (g * (1.0 - (0.314 * sepiaAmount))) +
              (b * 0.168 * sepiaAmount));
      color.b =
          min(1.0,
              (r * 0.272 * sepiaAmount) + (g * 0.534 * sepiaAmount) +
                  (b * (1.0 - (0.869 * sepiaAmount))));
      color *= (1.0 - darken);
  }

  outColor = vec4(color.r, color.g, color.b, 1.0);
}
]]

---- Lua code ----

-- Helper functions to construct animation curves
function makeKeyframe(timestamp, value, curve)
  return [[{"timestamp": ]] .. tostring(timestamp) .. [[, "value": ]] .. tostring(value) .. [[, "curve": "]] .. curve .. [["}]]
end

function makeJSONAnimationCurve(uniformName, animationCurve)
  return [["]] .. uniformName .. [[": []] .. animationCurve .. "]"
end

function makeJSONCurves(curve1, curve2, curve3)
  return [[{]] .. curve1 .. "," .. curve2 .. "," .. curve3 .. [[}]]
end

-- Get the median of a table.
function table.median( t )
  local temp={}

  -- deep copy table so that when we sort it, the original is unchanged
  -- also weed out any non numbers
  for k,v in pairs(t) do
    if type(v) == 'number' then
      table.insert( temp, v )
    end
  end

  table.sort( temp )

  -- If we have an even number of table elements or odd.
  if math.fmod(#temp,2) == 0 then
    -- return mean value of middle two elements
    return ( temp[#temp/2] + temp[(#temp/2)+1] ) / 2
  else
    -- return middle element
    return temp[math.ceil(#temp/2)]
  end
end

function table.contains(table, element)
  for _, value in pairs(table) do
      if value == element then
          return true
      end
  end
  return false
end

function getBeatInfo()
  local beatsTable = {}
  local prevStart = 0
  local beatDurations = {}
  local medianDuration = -1
  for _, mediaEvent in ipairs(MediaEvents) do
      if mediaEvent:getSourceMedia() == "config" then goto CONTINUE end
      local numEvents = mediaEvent:size()
      local onsetsAfter = 0
      for i = 0, numEvents - 1, 1 do
      -- check 'beat' tag in an event
      local start, weights, _, tags = mediaEvent:getEvent(i)
      if (table.contains(tags, "beat") and table.contains(tags, "onset") ) then
          -- save previous beat's onsets after the beat
          if #beatsTable ~= 0 then
              beatsTable[#beatsTable].onsetsAfter = onsetsAfter
          end
          -- save the new beat
          local beat = {
              startTime = start,
              weight = weights,
              onset = table.contains(tags, "onset"),
              onsetsBefore = onsetsAfter, -- onsets before beat are previous beat's onsets after the beat
              onsetsAfter = 0, -- This will be updated by the next beat.
          }
          table.insert(beatsTable, beat)
          onsetsAfter = 0
          -- save the beat duration
          local currDuration = start - prevStart
          table.insert(beatDurations, currDuration)
          prevStart = start
      else
          if #beatsTable ~= 0 then
              onsetsAfter = onsetsAfter + 1
          end
      end
      end
      ::CONTINUE::
  end

  if #beatDurations > 1 then
      medianDuration = table.median(beatDurations)
  end

  return beatsTable, medianDuration
end

function addClip(clipDuration, mediaIndex)
  local mediaItem = MediaItems[mediaIndex]
  local startTime = mediaItem:getStartSec()
  local speed = 1.0
  Project:addClip(startTime, clipDuration, speed, mediaItem)
end

function addEffect(duration, isSingleMediaEnabled)
  if (isSingleMediaEnabled) then
    local currentTime = 0.0
    ----- 1
    local endTime = currentTime + 0.5 * duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMS_1)
    currentTime = endTime

    endTime = currentTime + 0.25 * duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMSLEFT)
    Treatments:saturationTreatment(currentTime, endTime, SATURATION)
    local whiteTreatmentDuration = 0.10
    Treatments:whiteTreatment(currentTime, currentTime + whiteTreatmentDuration, WHITE_PARAMS_TR)
    Treatments:whiteTreatment(currentTime + whiteTreatmentDuration, currentTime + whiteTreatmentDuration + 0.10, WHITE_PARAMS_TR)
    currentTime = endTime

    endTime = currentTime + 0.25 * duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMSRIGHT)
    Treatments:saturationTreatment(currentTime, endTime, SATURATION2)
    Treatments:tintTreatment(currentTime, endTime, TINT)
    Treatments:sepiaTreatment(currentTime, endTime, SEPIA)
    currentTime = endTime

    --- 2
    endTime = currentTime + 0.5 * duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMS_1)
    currentTime = endTime

    endTime = currentTime + 0.25 * duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMSLEFT)
    Treatments:saturationTreatment(currentTime, endTime, SATURATION)
    local whiteTreatmentDuration = 0.10
    Treatments:whiteTreatment(currentTime, currentTime + whiteTreatmentDuration, WHITE_PARAMS_TR)
    Treatments:whiteTreatment(currentTime + whiteTreatmentDuration, currentTime + whiteTreatmentDuration + 0.10, WHITE_PARAMS_TR)
    currentTime = endTime

    endTime = currentTime + 0.25 * duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMSRIGHT)
    Treatments:saturationTreatment(currentTime, endTime, SATURATION2)
    Treatments:tintTreatment(currentTime, endTime, TINT)
    Treatments:sepiaTreatment(currentTime, endTime, SEPIA)
    currentTime = endTime

    ----- end
    endTime = currentTime + duration
    Treatments:transformTreatment(currentTime, endTime, T_PARAMSOUTRO)
    Project:addEffect("fadeOut", 0.5);
  else
    Treatments:transformTreatment(0.0, 0.5*duration, T_PARAMS_1)

    Treatments:transformTreatment(0.5*duration, 0.75*duration, T_PARAMSLEFT)
    Treatments:saturationTreatment(0.5*duration, 0.75*duration, SATURATION)
    Treatments:whiteTreatment(0.5*duration, 0.5*duration + 0.10, WHITE_PARAMS_TR)
    Treatments:whiteTreatment(0.5*duration + 0.10, 0.5*duration + 0.20, WHITE_PARAMS_TR)

    Treatments:transformTreatment(0.75*duration, duration, T_PARAMSRIGHT)
    Treatments:saturationTreatment(0.75*duration, duration, SATURATION2)
    Treatments:tintTreatment(0.75*duration, duration, TINT)
    Treatments:sepiaTreatment(0.75*duration, duration, SEPIA)
  end
end

function addEffectOptimized(duration, isSingleMediaEnabled)
  local function radianceEffect(startTime, duration)
    Treatments:transformTreatment(startTime, startTime + 0.5*duration, T_PARAMS_1)

    Treatments:transformTreatment(startTime + 0.5*duration, startTime + duration, [[{
      "start_zoom": 1.6,
      "mid_zoom": 1.6,
      "end_zoom": 1.6,
      "mid_point": 0.5,
      "start_angle": 0.5,
      "mid_angle": 0.0,
      "end_angle": -0.5,
      "global": false,
      "start_curve": "CONSTANT",
      "end_curve": "CONSTANT"
    }]])

    -- Prepare animation curves
    local float1 = makeKeyframe(startTime, 0.0, "CONSTANT")
    float1 = float1 .. "," .. makeKeyframe(startTime + 0.5*duration, 0.5, "CONSTANT")
    float1 = float1 .. "," .. makeKeyframe(startTime + 0.75*duration, 0.75, "CONSTANT")
    float1 = makeJSONAnimationCurve("float1", float1)

    local float2 = makeKeyframe(0.0, 0.0, "CONSTANT")
    float2 = makeJSONAnimationCurve("float2", float2)

    local float3 = makeKeyframe(0.0, 0.0, "CONSTANT")
    float3 = makeJSONAnimationCurve("float3", float3)

    local curves = makeJSONCurves(float1, float2, float3)

    ShaderEffects:addShader(VERTEX_SHADER_SATURATION_TINT_SEPIA, FRAGMENT_SHADER_SATURATION_TINT_SEPIA, startTime + 0.5*duration, startTime + duration, curves);

    Treatments:flashTreatment(startTime + 0.5*duration, startTime + 0.5*duration + 0.2, [[
      {
        "curve": "TRIANGLE"
      }
    ]])
  end

  if (isSingleMediaEnabled) then
    local currentTime = 0.0
    for i = 0, 2, 1 do

      radianceEffect(currentTime, duration)
      currentTime = currentTime + duration
    end

    Treatments:transformTreatment(currentTime, duration, T_PARAMSOUTRO)
    Project:addEffect("fadeOut", 0.5);
  else
    radianceEffect(0.0, duration)
  end
end

function getConfig()
  -- default config
  local config = {
      maxItemCount = 15,
      isVideoSegmentationEnabled = false,
      minVideoSegmentDuration = 30,
      seedValue = 0,
      shouldAllowDuplicatedMedia = true,
      shouldEnableSingleMediaLogic = false,
      shouldEnableTemplatesOptimization = false
  }

  for _, mediaEvent in ipairs(MediaEvents) do
      if mediaEvent:getSourceMedia() == "config" then
      for i = 0, mediaEvent:size() - 1, 1 do
          local startTime, weight, duration, tags = mediaEvent:getEvent(i)
          local param = tags[1]
          if param == "maxItemCount" then
            config.maxItemCount = math.floor(weight)
          elseif param == "isVideoSegmentationEnabled" then
            config.isVideoSegmentationEnabled = weight == 1.0
          elseif param == "minVideoSegmentDuration" then
            config.minVideoSegmentDuration = math.floor(weight)
          elseif param == "seed" then
            config.seedValue = math.floor(weight)
          elseif param == "shouldAllowDuplicatedMedia" then
            config.shouldAllowDuplicatedMedia = param
          elseif param == "shouldEnableSingleMediaLogic" then
            config.shouldEnableSingleMediaLogic = weight == 1.0
          elseif param == "shouldEnableTemplatesOptimization" then
            config.shouldEnableTemplatesOptimization = weight == 1.0
          end
      end
      end
  end

  return config
end

local config = getConfig()

function main()
  -- Keep only beats that fit in the suggested timeline
  -- https://www.wolframalpha.com/input?i=0.02+*+%28x+%5E+2%29+-+0.6+*+x+%2B+6%2C+x+from+1.0+to+15&fbclid=IwAR28NqOXDY9gC2qRCoc5yoEzfyEdBjtZzgz4-XIP2Gw7rqxDu3r7oBg5etM
  local numMediaItems = #MediaItems
  local suggestedClipDuration = 0.02 * (numMediaItems ^ 2) - 0.6 * numMediaItems + 6
  local maxTimelineDuration = suggestedClipDuration * numMediaItems

  -- Find beatDuration
  local _, beatDuration = getBeatInfo()

  for i = 1, numMediaItems, 1 do
    -- Sync clip to the beat
    local clipDuration = suggestedClipDuration
    if (beatDuration > 0.0 and suggestedClipDuration > beatDuration) then
        local beatsCount = math.floor(suggestedClipDuration/beatDuration)
        clipDuration = beatsCount * beatDuration
    end

    local mediaItem = MediaItems[i]
    if (mediaItem:isVideo()) then
        local mediaDuration = mediaItem:getDurationSec()
        if (mediaDuration < clipDuration) then
            -- In this case ignore the beat
            clipDuration = mediaDuration
        end
    end

    addClip(clipDuration, i)
    if (i ~= numMediaItems) then
      if (config.shouldEnableTemplatesOptimization) then
        addEffectOptimized(clipDuration, false);
      else
        addEffect(clipDuration, false);
      end
    else
      Treatments:transformTreatment(0.0, clipDuration, T_PARAMSOUTRO)
      Project:addEffect("fadeOut", 0.5);
    end

  end
end

function radianceSingleMedia()
  local suggestedEffectChangeInSec = 2.6
  -- Find beatDuration
  local _, beatDuration = getBeatInfo()
  if (beatDuration > 0.0 and suggestedEffectChangeInSec > beatDuration) then
    local beatsCount = math.floor(suggestedEffectChangeInSec/beatDuration)
    suggestedEffectChangeInSec = beatsCount * beatDuration
  end

  local suggestedClipDuration = 3 * suggestedEffectChangeInSec
  addClip(suggestedClipDuration, 1)

  if (config.shouldEnableTemplatesOptimization) then
    addEffectOptimized(suggestedEffectChangeInSec, true);
  else
    addEffect(suggestedEffectChangeInSec, true);
  end

end

if (#MediaItems == 1 and config.shouldEnableSingleMediaLogic) then
  radianceSingleMedia()
else
  main()
end
