-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

VERTEX_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
layout(location = 0) in vec4 inPosition;
layout(location = 1) in vec2 inTexCoord0;
out vec2 texCoord0;

void main(void) {
  gl_Position = inPosition;
  texCoord0 = inTexCoord0;
}
]]

FRAGMENT_SHADER = [[
precision highp float; // fill 1st line to help auto-indent
in vec2 texCoord0;
uniform sampler2D texture0;
uniform float float1;
uniform float float2;
uniform float float3;
layout(location = 0) out vec4 outColor;

//
// Box position and size
//

const vec4 boxParams[16] = vec4[16](
    vec4(-0.1, -0.3, 0.3, 0.7),
    vec4(-0.7, -0.3, 0.3, 0.7),
    vec4( 0.6, -0.3, 0.4, 0.7),
    vec4( 0.0,  0.7, 1.0, 0.3),

    vec4(-0.1,  0.3, 0.3, 0.7),
    vec4(-0.7,  0.3, 0.3, 0.7),
    vec4( 0.6,  0.3, 0.4, 0.7),
    vec4( 0.0, -0.7, 1.0, 0.3),

    vec4( 0.0, -0.8, 1.0, 0.2),
    vec4( 0.0, -0.3, 1.0, 0.3),
    vec4( 0.0,  0.3, 1.0, 0.3),
    vec4( 0.0,  0.8, 1.0, 0.2),

    vec4(-0.2,  0.0, 0.2, 1.0),
    vec4(-0.7,  0.0, 0.3, 1.0),
    vec4( 0.8,  0.0, 0.2, 1.0),
    vec4( 0.3,  0.0, 0.3, 1.0)
);

//
// Box sdf
//

float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,0.0)) + min(max(d.x,d.y),0.0);
}

//
// Main
//

void main(void)
{
    // Νormalized pixel coordinates
    ivec2 tsi = textureSize(texture0, 0);
    vec2 ts = vec2(float(tsi.x), float(tsi.y));
    vec2 p = (2.0 * gl_FragCoord.xy - ts.xy) / ts.y;
    p.y = -p.y;
    vec2 uv2 = texCoord0;
    float ar = ts.x / ts.y;
    float iTime = float1;

    // Box offsets
    vec4 boxOffsets[16] = vec4[16](
      vec4(0.0, -1.4, 1.0, 1.0),
      vec4(0.0, -1.4, 1.0, 1.0),
      vec4(0.0, -1.4, 1.0, 1.0),
      vec4(-2.0, 0.0, ar, 1.0),

      vec4(0.0,  1.4, 1.0, 1.0),
      vec4(0.0,  1.4, 1.0, 1.0),
      vec4(0.0,  1.4, 1.0, 1.0),
      vec4(-2.0, 0.0, ar, 1.0),

      vec4(-2.0, 0.0, ar, 1.0),
      vec4(2.0, 0.0, ar, 1.0),
      vec4(-2.0, 0.0, ar, 1.0),
      vec4(2.0, 0.0, ar, 1.0),

      vec4(0.0, -2.0, ar, 1.0),
      vec4(0.0, 2.0, ar, 1.0),
      vec4(0.0, -2.0, ar, 1.0),
      vec4(0.0, 2.0, ar, 1.0)
    );

    // Τime definitions
    float panDuration = 1.0;
    float borderEliminationDuration = 0.5;
    float holdTime = 0.3;

    // Box pan timing (start offset, duration)
    vec2 boxTiming[16] = vec2[16](
      vec2(0.0               , panDuration      ),
      vec2(-panDuration      , panDuration      ),
      vec2(-panDuration * 2.0, panDuration      ),
      vec2(0.0               , 3.0 * panDuration),

      vec2(0.0               , panDuration      ),
      vec2(-panDuration      , panDuration      ),
      vec2(-panDuration * 2.0, panDuration      ),
      vec2(0.0               , 3.0 * panDuration),

      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),

      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration),
      vec2(0.0               , 2.0 * panDuration)
    );

    // Border timing (start offset, duration)
    vec2 borderTiming[4] = vec2[4](
      vec2(-3.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-3.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-2.0 * panDuration - holdTime, borderEliminationDuration),
      vec2(-2.0 * panDuration - holdTime, borderEliminationDuration)
    );

    // Pick box layout
    int startIndex = int(float2) * 4;

    // Border and rounding
    float borderTimeIn = fract(min(max(iTime + borderTiming[startIndex / 4].x, 0.0), borderTiming[startIndex / 4].y - 1e-6) / borderTiming[startIndex / 4].y);
    //float borderTimeOut = fract(min(max(iTime + borderTiming[startIndex / 4].z, 0.0), borderTiming[startIndex / 4].w - 1e-6) / borderTiming[startIndex / 4].w);
    //float borderTime = min(borderTimeIn, borderTimeOut);
    float rounding = 0.1 * (borderEliminationDuration - borderTimeIn);
    float padding = 0.0025 * (borderEliminationDuration - borderTimeIn);

    // Boxes
    float d = 1e1;
    for (int i = startIndex; i < startIndex + 4; i++) {
      float time = fract(min(max(iTime + boxTiming[i].x, 0.0), boxTiming[i].y - 1e-6) / boxTiming[i].y);
      vec4 bp = boxParams[i];
      vec4 bo = boxOffsets[i];
      vec2 p = p + bp.xy * vec2(ar, 1.0) + bo.xy * bo.zw * (1.0 - time);
      vec2 v = bp.zw * vec2(ar, 1.0) - rounding - padding;
      float distance = sdBox(p, v) - rounding;

      // Union of shapes
      d = min(distance, d);
    }

    vec3 col = (vec3(1.0) - sign(d));

    // Smoothing
    col *= 1.0 - exp(-512.0 * abs(d));
    col = min(col, vec3(1.0));

    col *= texture(texture0, uv2).rgb;

    outColor = vec4(col, 1.0);
}
]]


---- Lua code ----

EFFECT = [[
    {
      "start_amount": 0.0,
      "end_amount": 0.0,
      "curve": "LINEAR"
    }
  ]];

CURVES = [[
    {
      "float1": [{"timestamp": 0.0, "value": 0.0, "curve": "LINEAR"},
                 {"timestamp": 12.0, "value": 12.0, "curve": "LINEAR"}],
      "float2": [{"timestamp": 0.0, "value": 0.0, "curve": "CONSTANT"},
                 {"timestamp": 12.0, "value": 0.0, "curve": "CONSTANT"}],
      "float3": [{"timestamp": 0.0, "value": 0.0, "curve": "CONSTANT"},
                 {"timestamp": 12.0, "value": 0.0, "curve": "CONSTANT"}]
    }
  ]];

function addClip(clipDuration, mediaIndex)
  local mediaItem = MediaItems[mediaIndex]
  local startTime = mediaItem:getStartSec()
  local speed = 1.0
  Project:addClip(startTime, clipDuration, speed, mediaItem)
end

-- Variable to keep track of clip start times
local absoluteStartTime = 0.0

function main()
  local numMediaItems = #MediaItems
  local suggestedClipDuration = 8
  local maxTimelineDuration = 30

  for i = 1, numMediaItems, 1 do
    local clipDuration = suggestedClipDuration

    -- Sanity checks for clip durations if input is video
    local mediaItem = MediaItems[i]
    if (mediaItem:isVideo()) then
        local mediaDuration = mediaItem:getDurationSec()
        -- Allow full video duration if it's less that maximum allowed
        if (absoluteStartTime + mediaDuration <= maxTimelineDuration) then
            clipDuration = mediaDuration
        else
        -- Otherwise trim to fit
            clipDuration = maxTimelineDuration - absoluteStartTime
        end
    end

    -- Add clip
    addClip(clipDuration, i)

    -- Cropping to rationalize texture coords
    Treatments:zoomTreatment(absoluteStartTime, absoluteStartTime + clipDuration, EFFECT)

    -- Add heart effect
    ShaderEffects:addShader(VERTEX_SHADER, FRAGMENT_SHADER, 0, clipDuration, CURVES)

    -- Keep track of absolute start time of next clip
    absoluteStartTime = absoluteStartTime + clipDuration
  end
end

main()
