-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

-- effect types
PAN_UP = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.45,
    "ending_x": 0.5,
    "ending_y": 0.55,
    "curve": "LINEAR"
    }
]]
PAN_DOWN = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.55,
    "ending_x": 0.5,
    "ending_y": 0.45,
    "curve": "LINEAR"
    }
]]
PAN_RIGHT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.45,
    "starting_y": 0.5,
    "ending_x": 0.55,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
PAN_LEFT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.55,
    "starting_y": 0.5,
    "ending_x": 0.45,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
ZOOM_IN = [[
    {
      "start_amount": 0.0,
      "end_amount": 0.1,
      "curve": "LINEAR"
    }
  ]];
ZOOM_OUT = [[
    {
      "start_amount": 0.1,
      "end_amount": 0.0,
      "curve": "LINEAR"
    }
  ]];
SPARKLE = [[
  {
    "strength": 1.0,
    "size": 8.0,
    "threshold": 0.08
  }
]]

effects = {
    PAN_UP,
    PAN_DOWN,
    PAN_RIGHT,
    PAN_LEFT,
    ZOOM_IN,
    ZOOM_IN,
    ZOOM_OUT,
    ZOOM_OUT,
}

defaultEvents = {
    {weight = 0.2682280203736999,startTime = 0.03982285293675197,tags = { "beat", "inferred" }},
    {weight = -0.5012954611395465,startTime = 0.34300567463965104,tags = { "beat", "inferred" }},
    {weight = -0.5380822372064424,startTime = 0.6461884963425502,tags = { "beat", "inferred" }},
    {weight = 0.088709792191839,startTime = 0.949371318045449,tags = { "beat", "inferred" }},
    {weight = 0.6496726381106901,startTime = 1.2525541397483482,tags = { "beat", "inferred" }},
    {weight = 2.6130221290900884,startTime = 1.5557369614512473,tags = { "beat", "onset" }},
    {weight = -0.40526022772912035,startTime = 1.857596371882086,tags = { "beat", "inferred" }},
    {weight = 3.7314634193349705,startTime = 2.159455782312925,tags = { "beat", "onset" }},
    {weight = -0.4436714643720043,startTime = 2.461315192743764,tags = { "beat", "inferred" }},
    {weight = -0.45455860374398044,startTime = 2.763174603174603,tags = { "beat", "inferred" }},
    {weight = -0.5511237591586835,startTime = 3.065034013605442,tags = { "beat", "inferred" }},
    {weight = -0.58164428419364,startTime = 3.366893424036281,tags = { "beat", "inferred" }},
    {weight = -0.5906122048033771,startTime = 3.66875283446712,tags = { "beat", "inferred" }},
    {weight = 3.0048434047763037,startTime = 3.9706122448979593,tags = { "beat", "onset" }},
    {weight = -0.3839456060158246,startTime = 4.276341647770219,tags = { "beat", "inferred" }},
    {weight = -0.5682639748602442,startTime = 4.5820710506424795,tags = { "beat", "inferred" }},
    {weight = 2.5936475763392774,startTime = 4.887800453514739,tags = { "beat", "onset" }},
    {weight = -0.5690744406230804,startTime = 5.189659863945578,tags = { "beat", "inferred" }},
    {weight = -0.5231059048407685,startTime = 5.491519274376417,tags = { "beat", "inferred" }},
    {weight = -0.2682608630931871,startTime = 5.793378684807257,tags = { "beat", "inferred" }},
    {weight = 1.8445505937577495,startTime = 6.095238095238096,tags = { "beat", "inferred" }},
    {weight = 3.3999759738750313,startTime = 6.397097505668935,tags = { "beat", "onset" }},
    {weight = -0.440526915838389,startTime = 6.698956916099774,tags = { "beat", "inferred" }},
    {weight = 3.3005622770093037,startTime = 7.000816326530613,tags = { "beat", "onset" }},
    {weight = -0.4254171294068304,startTime = 7.304610733182162,tags = { "beat", "inferred" }},
    {weight = -0.25283238581277034,startTime = 7.608405139833711,tags = { "beat", "inferred" }},
    {weight = -0.3178239418662356,startTime = 7.912199546485261,tags = { "beat", "inferred" }},
    {weight = -0.5426736533767433,startTime = 8.21599395313681,tags = { "beat", "inferred" }},
    {weight = -0.5846636401336917,startTime = 8.51978835978836,tags = { "beat", "inferred" }},
    {weight = 4.190822927638298,startTime = 8.823582766439909,tags = { "beat", "onset" }},
    {weight = -0.24173028265729915,startTime = 9.125442176870749,tags = { "beat", "inferred" }},
    {weight = -0.5811058285889885,startTime = 9.427301587301587,tags = { "beat", "inferred" }},
    {weight = 3.829198003677823,startTime = 9.729160997732427,tags = { "beat", "onset" }},
    {weight = -0.44230493304836666,startTime = 10.033342403628119,tags = { "beat", "inferred" }},
    {weight = 0.012972287384618086,startTime = 10.33752380952381,tags = { "beat", "inferred" }},
    {weight = -0.030039316102110008,startTime = 10.6417052154195,tags = { "beat", "inferred" }},
    {weight = 1.4715629278602715,startTime = 10.945886621315193,tags = { "beat", "inferred" }},
    {weight = 2.947392479116552,startTime = 11.250068027210885,tags = { "beat", "onset" }},
    {weight = -0.393501154928525,startTime = 11.551927437641723,tags = { "beat", "inferred" }},
    {weight = 4.164102206144981,startTime = 11.853786848072563,tags = { "beat", "onset" }},
    {weight = 0.546410704098526,startTime = 12.157581254724112,tags = { "beat", "inferred" }},
    {weight = -0.4378140236241403,startTime = 12.461375661375662,tags = { "beat", "inferred" }},
    {weight = -0.39174620068803684,startTime = 12.76517006802721,tags = { "beat", "inferred" }},
    {weight = -0.5675801855805203,startTime = 13.06896447467876,tags = { "beat", "inferred" }},
    {weight = 0.016147810727809523,startTime = 13.37275888133031,tags = { "beat", "inferred" }},
    {weight = 2.8998236123526118,startTime = 13.676553287981859,tags = { "beat", "onset" }},
    {weight = -0.41480771096875313,startTime = 13.978412698412699,tags = { "beat", "inferred" }},
    {weight = -0.5618031756480403,startTime = 14.280272108843537,tags = { "beat", "inferred" }},
    {weight = 3.7293153206061613,startTime = 14.582131519274377,tags = { "beat", "onset" }},
    {weight = -0.5647117233432541,startTime = 14.883990929705217,tags = { "beat", "inferred" }},
    {weight = 0.46591681025462456,startTime = 15.185850340136055,tags = { "beat", "inferred" }},
    {weight = -0.38886482217659013,startTime = 15.487709750566893,tags = { "beat", "inferred" }},
    {weight = 2.3512536265122055,startTime = 15.789569160997733,tags = { "beat", "onset" }},
    {weight = 2.3200571318939334,startTime = 16.091428571428573,tags = { "beat", "onset" }},
    {weight = -0.30067657876511705,startTime = 16.394739229024943,tags = { "beat", "inferred" }},
    {weight = 2.0196863334438846,startTime = 16.698049886621316,tags = { "beat", "inferred" }},
    {weight = -0.1006511784195355,startTime = 17.00136054421769,tags = { "beat", "inferred" }},
    {weight = -0.030259964062025056,startTime = 17.30467120181406,tags = { "beat", "inferred" }},
    {weight = 0.29515971829144577,startTime = 17.60798185941043,tags = { "beat", "inferred" }},
    {weight = -0.4181967409476089,startTime = 17.911292517006803,tags = { "beat", "inferred" }},
    {weight = 0.4125820938869672,startTime = 18.214603174603177,tags = { "beat", "inferred" }},
    {weight = 2.8033844309433267,startTime = 18.517913832199547,tags = { "beat", "onset" }},
    {weight = -0.26305013260503113,startTime = 18.819773242630387,tags = { "beat", "inferred" }},
    {weight = -0.4536377593299611,startTime = 19.121632653061223,tags = { "beat", "inferred" }},
    {weight = 5.167742132287506,startTime = 19.423492063492063,tags = { "beat", "onset" }},
    {weight = 2.095665571302104,startTime = 19.736961451247165,tags = { "beat", "inferred" }},
    {weight = 3.652231602695373,startTime = 20.050430839002267,tags = { "beat", "onset" }},
    {weight = 8.542507641422329,startTime = 20.340680272108845,tags = { "beat", "onset" }},
    {weight = 2.1966320399885735,startTime = 20.642539682539685,tags = { "beat", "inferred" }},
    {weight = 5.489670222777604,startTime = 20.94439909297052,tags = { "beat", "onset" }},
    {weight = 10.24065916830581,startTime = 21.24625850340136,tags = { "beat", "onset" }},
    {weight = 3.3080192200745273,startTime = 21.559727891156463,tags = { "beat", "onset" }},
    {weight = 5.439281344033069,startTime = 21.84997732426304,tags = { "beat", "onset" }},
    {weight = -0.28178341116374017,startTime = 22.140226757369618,tags = { "beat", "inferred" }},
    {weight = 2.5755000704812256,startTime = 22.430476190476192,tags = { "beat", "onset" }},
    {weight = 2.8536705570929115,startTime = 22.709115646258503,tags = { "beat", "onset" }},
    {weight = 0.09812388644385875,startTime = 23.04,tags = { "beat", "inferred" }},
    {weight = 5.592377822938842,startTime = 23.3708843537415,tags = { "beat", "onset" }},
    {weight = 7.71135013362179,startTime = 23.672743764172335,tags = { "beat", "onset" }},
    {weight = 2.646698900118924,startTime = 23.986213151927437,tags = { "beat", "onset" }},
    {weight = 7.458865879882285,startTime = 24.276462585034015,tags = { "beat", "onset" }},
    {weight = 1.3515199310705068,startTime = 24.578321995464854,tags = { "beat", "inferred" }},
    {weight = 1.0431139687189923,startTime = 24.88018140589569,tags = { "beat", "inferred" }},
    {weight = 11.222768722193221,startTime = 25.18204081632653,tags = { "beat", "onset" }},
    {weight = 2.298697878769281,startTime = 25.48390022675737,tags = { "beat", "onset" }},
    {weight = 4.127339692885681,startTime = 25.78575963718821,tags = { "beat", "onset" }},
    {weight = 5.777913682967249,startTime = 26.099229024943313,tags = { "beat", "onset" }},
    {weight = 2.84422979984417,startTime = 26.377868480725624,tags = { "beat", "onset" }},
    {weight = 5.94718101816562,startTime = 26.70294784580499,tags = { "beat", "onset" }},
    {weight = 1.5113922461820668,startTime = 27.00480725623583,tags = { "beat", "inferred" }},
    {weight = 2.2209977980587676,startTime = 27.30666666666667,tags = { "beat", "onset" }},
    {weight = 13.968864770765087,startTime = 27.608526077097505,tags = { "beat", "onset" }},
    {weight = 1.5024045775671666,startTime = 27.910385487528345,tags = { "beat", "inferred" }},
    {weight = 5.518005137468539,startTime = 28.212244897959184,tags = { "beat", "onset" }},
    {weight = 8.090284649252103,startTime = 28.514104308390024,tags = { "beat", "onset" }},
    {weight = 2.9341155251012214,startTime = 28.804353741496598,tags = { "beat", "onset" }},
    {weight = 4.969736301317163,startTime = 29.129433106575963,tags = { "beat", "onset" }}
}

-- util functions
function table.contains(table, element)
    for _, value in pairs(table) do
        if value == element then
            return true
        end
    end
    return false
end

function table.size(table)
    local ret = 0
    for _, v in pairs(table) do
        ret = ret + 1
    end
    return ret
end

function sortFunc(a, b)
    if a.onset and not b.onset then
        return true
    elseif b.onset and not a.onset then
        return false
    elseif a.weights > b.weights then
        return true
    elseif a.weights < b.weights then
        return false
    elseif a.diffToSuggestion < b.diffToSuggestion then
        return true
    elseif a.diffToSuggestion > b.diffToSuggestion then
        return false
    else
        return false
    end
end

function pickBestBeat(inputCandidates)
    table.sort(inputCandidates, sortFunc)

    for k, v in pairs(inputCandidates) do
        if (k == 1) then
            return v
        end
    end
end

function addTreatment()
    local treatmentStart = 0.0
    local treatmentEnd = 6.0
    local effect = effects[math.random(#(effects))]
    if effect == PAN_UP or effect == PAN_DOWN or effect == PAN_RIGHT or effect == PAN_LEFT then
        Treatments:panTreatment(treatmentStart, treatmentEnd, effect);
    elseif effect == ZOOM_IN or effect == ZOOM_OUT then
        Treatments:zoomTreatment2(treatmentStart, treatmentEnd, effect);
    end
end

function shouldAddTransition(mediaIndex, mediaItemsSize)
    return mediaIndex < mediaItemsSize
end

function generateMediaItemsWithSegments()
    local mediaItemsCount = table.size(MediaItems)
    local availableSegmentCount = _config.maxItemCount - mediaItemsCount
    local list = {}
    local offset = 0
    for i = 1, mediaItemsCount, 1 do
        local item = MediaItems[i]
        local startTime = item:getStartSec()
        local duration = item:getDurationSec()

        list[i + offset] = {}
        list[i + offset]["originalIndex"] = i
        list[i + offset]["startTime"] =  startTime

        if _config.isVideoSegmentationEnabled and not item:isImage() and duration > _config.minVideoSegmentDuration and availableSegmentCount > 0 then
            local interval = duration / 3
            for j = 1, 2, 1 do
                if availableSegmentCount > 0 then
                    offset = offset + 1
                    availableSegmentCount = availableSegmentCount - 1

                    list[i + offset] = {}
                    list[i + offset]["originalIndex"] = i
                    list[i + offset]["startTime"] = startTime + (interval * j)
                end
            end
        end
    end
    return list
end

function getConfig()
    -- default config
    local config = {
        maxItemCount = 15,
        isVideoSegmentationEnabled = false,
        minVideoSegmentDuration = 30,
        seedValue = 0
    }

    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            for i = 0, mediaEvent:size() - 1, 1 do
                local startTime, weight, duration, tags = mediaEvent:getEvent(i)
                local param = tags[1]
                if param == "maxItemCount" then
                    config.maxItemCount = math.floor(weight)
                elseif param == "isVideoSegmentationEnabled" then
                    config.isVideoSegmentationEnabled = weight == 1.0
                elseif param == "minVideoSegmentDuration" then
                    config.minVideoSegmentDuration = math.floor(weight)
                elseif param == "seed" then
                    config.seedValue = math.floor(weight)
                end
            end
        end
    end

    return config
end

function isMediaEventsEmpty()
    local configFilesAmt = 0
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            configFilesAmt = configFilesAmt + 1
        end
    end

    local resultingTableSize = table.size(MediaEvents) - configFilesAmt
    return resultingTableSize == 0

end

function mediaEventToTable(mediaEvent)
    local numEvents = mediaEvent:size()
    local eventsTable = {}
    for i = 0, numEvents - 1, 1 do
        local start, weights, _, tag = mediaEvent:getEvent(i)
        local event = {
            startTime = start,
            weight = weights,
            tags = tag
        }
        table.insert(eventsTable, event)
    end
    return eventsTable
end


-- const values
_trimThreshold = 1.0
_fadeOutDuration = 0.5
_transitionDuration = 0.6
_config = getConfig()
_mediaItemsWithSegments = generateMediaItemsWithSegments()

-- main function
function main()
    -- set seed if necessary
    if _config.seedValue > 0 then
        math.randomseed(_config.seedValue)
    end

    -- media items size
    local mediaItemsSize = table.size(_mediaItemsWithSegments)

    -- calculate minimum clip duration given the media item size
    local suggestedDuration = 0.02 * (mediaItemsSize ^ 2) - 0.6 * mediaItemsSize + 6

    -- if no media event exists, make transitions at suggested duration
    if (isMediaEventsEmpty()) then
        events = defaultEvents
    end

    -- initial item info
    local mediaItemIndex = 1
    local mediaItem = _mediaItemsWithSegments[mediaItemIndex]
    local originalMediaItem = MediaItems[mediaItem.originalIndex]

    if (originalMediaItem:isImage()) then
        mediaItemDuration = suggestedDuration
    else
        mediaItemDuration = math.min(originalMediaItem:getDurationSec(), suggestedDuration)
    end

    -- loop through events
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then goto CONTINUE end
        events = mediaEventToTable(mediaEvent)

        -- if no media event exists, make transitions at defaultEvents values
        if (#events == 0) then
            events = defaultEvents
        end
        ::CONTINUE::
    end

    local numEvents = #events
    local prevTransitionTime = 0
    local didAddClip = false
    local leftBound = prevTransitionTime + mediaItemDuration - _trimThreshold     -- time stamp for left bound of selected media item
    local rightBound = prevTransitionTime + mediaItemDuration + _trimThreshold    -- time stamp for right bound of selected media item
    local candidates = {}   -- table for transition candidates. candidate example: { onset = true, weights = 1.2, diffToSuggestion: 0.24 }

    -- loop through media events
    for i = 1, numEvents, 1 do
        -- check 'beat' tag in an event and make transition
        local event = events[i]
        if (table.contains(event.tags, "beat")) then
            if (event.startTime >= leftBound and event.startTime <= rightBound) then
                local candidate = {
                    start = event.startTime,
                    onset = table.contains(event.tags, "onset"),
                    weights = event.weight,
                    diffToSuggestion = math.abs(prevTransitionTime + mediaItemDuration - event.startTime)
                }
                table.insert(candidates, candidate)
            end
        end

        -- beat passed right bound
        if (event.startTime > rightBound) then
            local clipDuration = mediaItemDuration
            local bestBeat = pickBestBeat(candidates)
            if bestBeat ~= nil then
                clipDuration = bestBeat.start - prevTransitionTime
            end

            Project:addClip(mediaItem.startTime, clipDuration, 1.0, originalMediaItem)

            if (originalMediaItem:isImage()) then
                addTreatment()
            end

            if shouldAddTransition(mediaItemIndex, mediaItemsSize) then
                Project:addTransition("dissolve", _transitionDuration)
            end

            prevTransitionTime = prevTransitionTime + clipDuration - _transitionDuration

            didAddClip = true
            candidates = {}
            i = i - 1
        end

        -- update params for next media item
        if (didAddClip) then
            mediaItemIndex = mediaItemIndex + 1

            if (mediaItemIndex > mediaItemsSize) then
                break
            end

            mediaItem = _mediaItemsWithSegments[mediaItemIndex]
            originalMediaItem = MediaItems[mediaItem.originalIndex]

            if (originalMediaItem:isImage()) then
                mediaItemDuration = suggestedDuration
            else
                mediaItemDuration = math.min(originalMediaItem:getDurationSec() - mediaItem.startTime, suggestedDuration)
            end

            leftBound = prevTransitionTime + mediaItemDuration - _trimThreshold
            rightBound = prevTransitionTime + mediaItemDuration + _trimThreshold

            didAddClip = false
        end
    end

    -- handle remaining items
    while (mediaItemIndex <= mediaItemsSize) do
        mediaItem = _mediaItemsWithSegments[mediaItemIndex]
        originalMediaItem = MediaItems[mediaItem.originalIndex]

        if (originalMediaItem:isImage()) then
            mediaItemDuration = suggestedDuration
        else
            mediaItemDuration = math.min(originalMediaItem:getDurationSec() - mediaItem.startTime, suggestedDuration)
        end

        Project:addClip(mediaItem.startTime, mediaItemDuration, 1.0, originalMediaItem)

        if (originalMediaItem:isImage()) then
            addTreatment()
        end

        if shouldAddTransition(mediaItemIndex, mediaItemsSize) then
            Project:addTransition("dissolve", _transitionDuration)
        end

        mediaItemIndex = mediaItemIndex + 1
    end

    Project:addEffect("fadeOut", _fadeOutDuration)
end

main()
