-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

-- effect types
PAN_UP = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.45,
    "ending_x": 0.5,
    "ending_y": 0.55,
    "curve": "LINEAR"
    }
]]
PAN_DOWN = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.55,
    "ending_x": 0.5,
    "ending_y": 0.45,
    "curve": "LINEAR"
    }
]]
PAN_RIGHT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.45,
    "starting_y": 0.5,
    "ending_x": 0.55,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
PAN_LEFT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.55,
    "starting_y": 0.5,
    "ending_x": 0.45,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
ZOOM_IN = [[
    {
      "start_amount": 0.0,
      "end_amount": 0.1,
      "curve": "LINEAR"
    }
  ]];
ZOOM_OUT = [[
    {
      "start_amount": 0.1,
      "end_amount": 0.0,
      "curve": "LINEAR"
    }
  ]];
SEPIA = [[{
    "darken": 0.1,
    "sepia_amount": 0.1
}]]

defaultEvents = { {weight = 9.93337475256623,startTime = 0,tags = { "beat", "onset" }},
 {weight = 3.4343841636121835,startTime = 0.33668934240362813,tags = { "beat", "onset" }},
 {weight = -0.8376675550586856,startTime = 0.6559637188208617,tags = { "beat", "inferred" }},
 {weight = 3.566330316846637,startTime = 0.9752380952380952,tags = { "beat", "onset" }},
 {weight = 1.9303314609242894,startTime = 1.2654875283446712,tags = { "beat", "onset" }},
 {weight = 0.19667890646862704,startTime = 1.5866969009826153,tags = { "beat", "inferred" }},
 {weight = -0.5429257725440768,startTime = 1.9079062736205592,tags = { "beat", "inferred" }},
 {weight = 5.8401428623808584,startTime = 2.2291156462585033,tags = { "beat", "onset" }},
 {weight = 1.7179066535000491,startTime = 2.5658049886621317,tags = { "beat", "onset" }},
 {weight = 3.839634519385608,startTime = 2.8444444444444446,tags = { "beat", "onset" }},
 {weight = -0.2279316144211011,startTime = 3.152108843537415,tags = { "beat", "inferred" }},
 {weight = 2.3623219550071783,startTime = 3.4597732426303858,tags = { "beat", "onset" }},
 {weight = -0.6035259120247805,startTime = 3.7819501133786853,tags = { "beat", "inferred" }},
 {weight = -0.7095346212967057,startTime = 4.104126984126984,tags = { "beat", "inferred" }},
 {weight = -0.6565883000998566,startTime = 4.426303854875284,tags = { "beat", "inferred" }},
 {weight = 2.9203559030685446,startTime = 4.748480725623583,tags = { "beat", "onset" }},
 {weight = 1.3858611547042214,startTime = 5.061950113378685,tags = { "beat", "onset" }},
 {weight = 2.216545812530186,startTime = 5.352199546485261,tags = { "beat", "onset" }},
 {weight = -0.3073708250432379,startTime = 5.688888888888889,tags = { "beat", "inferred" }},
 {weight = -0.31221820813568374,startTime = 6.025578231292517,tags = { "beat", "inferred" }},
 {weight = -0.5726364214623444,startTime = 6.362267573696146,tags = { "beat", "inferred" }},
 {weight = 1.9670769529539522,startTime = 6.698956916099774,tags = { "beat", "onset" }},
 {weight = 2.0420142195987525,startTime = 7.024036281179138,tags = { "beat", "onset" }},
 {weight = 1.3804953443883135,startTime = 7.325895691609977,tags = { "beat", "onset" }},
 {weight = 2.6075920976341473,startTime = 7.685804988662132,tags = { "beat", "onset" }},
 {weight = -0.49632254263064035,startTime = 8.010884353741497,tags = { "beat", "inferred" }},
 {weight = 1.2432059443791066,startTime = 8.335963718820862,tags = { "beat", "onset" }},
 {weight = 0.29314611518463846,startTime = 8.678458049886622,tags = { "beat", "inferred" }},
 {weight = 4.53655816870276,startTime = 9.020952380952382,tags = { "beat", "onset" }},
 {weight = 2.2917047982682197,startTime = 9.299591836734693,tags = { "beat", "onset" }},
 {weight = -0.4748310176203081,startTime = 9.613061224489796,tags = { "beat", "inferred" }},
 {weight = 2.249834484331439,startTime = 9.926530612244898,tags = { "beat", "onset" }},
 {weight = -0.039956104858911226,startTime = 10.24,tags = { "beat", "inferred" }},
 {weight = 0.25047636494483677,startTime = 10.553469387755102,tags = { "beat", "inferred" }},
 {weight = 1.2842640945486694,startTime = 10.866938775510205,tags = { "beat", "onset" }},
 {weight = 3.3091539567603716,startTime = 11.180408163265307,tags = { "beat", "onset" }},
 {weight = 1.7421486188633677,startTime = 11.470657596371883,tags = { "beat", "onset" }},
 {weight = 2.477539200485431,startTime = 11.784126984126985,tags = { "beat", "onset" }},
 {weight = 1.0603745225291492,startTime = 12.178866213151927,tags = { "beat", "onset" }},
 {weight = -0.10269093436379276,startTime = 12.527165532879819,tags = { "beat", "inferred" }},
 {weight = 1.5998854607145947,startTime = 12.87546485260771,tags = { "beat", "onset" }},
 {weight = -0.5244332094637919,startTime = 13.194739229024943,tags = { "beat", "inferred" }},
 {weight = 3.04858768810626,startTime = 13.514013605442177,tags = { "beat", "onset" }},
 {weight = 2.810945603407339,startTime = 13.827482993197279,tags = { "beat", "onset" }},
 {weight = 2.3315278445428294,startTime = 14.199002267573697,tags = { "beat", "onset" }},
 {weight = 2.0682119459626795,startTime = 14.616961451247166,tags = { "beat", "onset" }},
 {weight = -0.8199011029061428,startTime = 14.969130763416478,tags = { "beat", "inferred" }},
 {weight = -0.03769222738872616,startTime = 15.321300075585789,tags = { "beat", "inferred" }},
 {weight = 2.9960579700697103,startTime = 15.673469387755102,tags = { "beat", "onset" }},
 {weight = 4.391237850683011,startTime = 16.021768707482995,tags = { "beat", "onset" }},
 {weight = 0.2950263923071318,startTime = 16.341043083900228,tags = { "beat", "inferred" }},
 {weight = 1.73114355033822,startTime = 16.66031746031746,tags = { "beat", "inferred" }},
 {weight = -0.7522921287299199,startTime = 16.979591836734695,tags = { "beat", "inferred" }},
 {weight = 1.6083118418515887,startTime = 17.29886621315193,tags = { "beat", "onset" }},
 {weight = 2.0673678589880637,startTime = 17.635555555555555,tags = { "beat", "onset" }},
 {weight = 2.135988872153893,startTime = 18.007074829931973,tags = { "beat", "onset" }},
 {weight = 2.527774901103634,startTime = 18.401814058956916,tags = { "beat", "onset" }},
 {weight = 1.6503789940863183,startTime = 18.773333333333333,tags = { "beat", "onset" }},
 {weight = 3.081218187845467,startTime = 19.075192743764173,tags = { "beat", "onset" }},
 {weight = 0.526612992941383,startTime = 19.408979591836736,tags = { "beat", "inferred" }},
 {weight = 0.4015182825267567,startTime = 19.742766439909296,tags = { "beat", "inferred" }},
 {weight = -0.7888723992314125,startTime = 20.07655328798186,tags = { "beat", "inferred" }},
 {weight = 2.4084353001057752,startTime = 20.410340136054423,tags = { "beat", "onset" }},
 {weight = 2.0878823806272955,startTime = 20.735419501133787,tags = { "beat", "onset" }},
 {weight = 0.4848996986005398,startTime = 21.04308390022676,tags = { "beat", "inferred" }},
 {weight = 3.52333354735208,startTime = 21.35074829931973,tags = { "beat", "onset" }},
 {weight = 1.6960074409295305,startTime = 21.745487528344672,tags = { "beat", "onset" }},
 {weight = -0.3350437164049115,startTime = 22.070566893424036,tags = { "beat", "inferred" }},
 {weight = 3.224387283048389,startTime = 22.3956462585034,tags = { "beat", "onset" }},
 {weight = 1.5730290466515964,startTime = 22.76716553287982,tags = { "beat", "onset" }},
 {weight = 1.7362062297009035,startTime = 23.1502947845805,tags = { "beat", "onset" }},
 {weight = 2.9352755241623365,startTime = 23.556643990929707,tags = { "beat", "onset" }},
 {weight = -0.2588388324607562,startTime = 23.90881330309902,tags = { "beat", "inferred" }},
 {weight = -0.7212294744276491,startTime = 24.26098261526833,tags = { "beat", "inferred" }},
 {weight = 4.803480720487154,startTime = 24.61315192743764,tags = { "beat", "onset" }},
 {weight = 3.0442519158210426,startTime = 24.91501133786848,tags = { "beat", "onset" }},
 {weight = -0.522764686390295,startTime = 25.234285714285715,tags = { "beat", "inferred" }},
 {weight = 3.4060042259961754,startTime = 25.55356009070295,tags = { "beat", "onset" }},
 {weight = 3.0520437886238327,startTime = 25.843809523809526,tags = { "beat", "onset" }},
 {weight = 0.06606607189960507,startTime = 26.17275888133031,tags = { "beat", "inferred" }},
 {weight = -0.7253415662645494,startTime = 26.501708238851098,tags = { "beat", "inferred" }},
 {weight = 2.9687515232130144,startTime = 26.830657596371882,tags = { "beat", "onset" }},
 {weight = -0.9771272905188475,startTime = 27.15960695389267,tags = { "beat", "inferred" }},
 {weight = -0.07516532085758336,startTime = 27.488556311413454,tags = { "beat", "inferred" }},
 {weight = 3.5067001030871503,startTime = 27.817505668934242,tags = { "beat", "onset" }},
 {weight = -0.7183005992896061,startTime = 28.13968253968254,tags = { "beat", "inferred" }},
 {weight = -1.084963203359633,startTime = 28.46185941043084,tags = { "beat", "inferred" }},
 {weight = -0.9042265791575866,startTime = 28.78403628117914,tags = { "beat", "inferred" }},
 {weight = 3.582047095150205,startTime = 29.106213151927438,tags = { "beat", "onset" }},
 {weight = -0.6302649660062116,startTime = 29.41968253968254,tags = { "beat", "inferred" }},
 {weight = 1.8097177001645681,startTime = 29.733151927437643,tags = { "beat", "onset" }}}

effects = {
    PAN_UP,
    PAN_DOWN,
    PAN_RIGHT,
    PAN_LEFT,
    ZOOM_IN,
    ZOOM_IN,
    ZOOM_OUT,
    ZOOM_OUT,
}

-- util functions
function table.contains(table, element)
    for _, value in pairs(table) do
        if value == element then
            return true
        end
    end
    return false
end

function table.size(table)
    local ret = 0
    for _, v in pairs(table) do
        ret = ret + 1
    end
    return ret
end

function sortFunc(a, b)
    if a.onset and not b.onset then
        return true
    elseif b.onset and not a.onset then
        return false
    elseif a.weights > b.weights then
        return true
    elseif a.weights < b.weights then
        return false
    elseif a.diffToSuggestion < b.diffToSuggestion then
        return true
    elseif a.diffToSuggestion > b.diffToSuggestion then
        return false
    else
        return false
    end
end

function pickBestBeat(inputCandidates)
    table.sort(inputCandidates, sortFunc)

    for k, v in pairs(inputCandidates) do
        if (k == 1) then
            return v
        end
    end
end

function addTreatment()
    local treatmentStart = 0.0
    local treatmentEnd = 6.0
    local effect = effects[math.random(#(effects))]
    if effect == PAN_UP or effect == PAN_DOWN or effect == PAN_RIGHT or effect == PAN_LEFT then
        Treatments:panTreatment(treatmentStart, treatmentEnd, effect);
    elseif effect == ZOOM_IN or effect == ZOOM_OUT then
        Treatments:zoomTreatment2(treatmentStart, treatmentEnd, effect);
    end
end

function shouldAddFadeTransition(mediaIndex, mediaItemsSize)
    return mediaIndex < mediaItemsSize
end


function generateMediaItemsWithSegments()
    local mediaItemsCount = table.size(MediaItems)
    local availableSegmentCount = _config.maxItemCount - mediaItemsCount
    local list = {}
    local offset = 0
    for i = 1, mediaItemsCount, 1 do
        local item = MediaItems[i]
        local startTime = item:getStartSec()
        local duration = item:getDurationSec()

        list[i + offset] = {}
        list[i + offset]["originalIndex"] = i
        list[i + offset]["startTime"] =  startTime

        if _config.isVideoSegmentationEnabled and not item:isImage() and duration > _config.minVideoSegmentDuration and availableSegmentCount > 0 then
            local interval = duration / 3
            for j = 1, 2, 1 do
                if availableSegmentCount > 0 then
                    offset = offset + 1
                    availableSegmentCount = availableSegmentCount - 1

                    list[i + offset] = {}
                    list[i + offset]["originalIndex"] = i
                    list[i + offset]["startTime"] = startTime + (interval * j)
                end
            end
        end
    end
    return list
end

function mediaEventToTable(mediaEvent)
    local numEvents = mediaEvent:size()
    local eventsTable = {}
    for i = 0, numEvents - 1, 1 do
        local start, weights, _, tag = mediaEvent:getEvent(i)
        local event = {
            startTime = start,
            weight = weights,
            tags = tag
        }
        table.insert(eventsTable, event)
    end
    return eventsTable
end

function getConfig()
    -- default config
    local config = {
        maxItemCount = 15,
        isVideoSegmentationEnabled = false,
        minVideoSegmentDuration = 30,
        seedValue = 0
    }

    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            for i = 0, mediaEvent:size() - 1, 1 do
                local startTime, weight, duration, tags = mediaEvent:getEvent(i)
                local param = tags[1]
                if param == "maxItemCount" then
                    config.maxItemCount = math.floor(weight)
                elseif param == "isVideoSegmentationEnabled" then
                    config.isVideoSegmentationEnabled = weight == 1.0
                elseif param == "minVideoSegmentDuration" then
                    config.minVideoSegmentDuration = math.floor(weight)
                elseif param == "seed" then
                    config.seedValue = math.floor(weight)
                end
            end
        end
    end

    return config
end

function isMediaEventsEmpty()
    local configFilesAmt = 0
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            configFilesAmt = configFilesAmt + 1
        end
    end

    local resultingTableSize = table.size(MediaEvents) - configFilesAmt
    return resultingTableSize == 0
end


-- const values
_trimThreshold = 1.0
_fadeOutDuration = 0.5
_config = getConfig()
_mediaItemsWithSegments = generateMediaItemsWithSegments()
_transitionDuration = 0.6

-- main function
function main()
    -- set seed if necessary
    if _config.seedValue > 0 then
        math.randomseed(_config.seedValue)
    end

    -- media items size
    local mediaItemsSize = table.size(_mediaItemsWithSegments)

    -- calculate minimum clip duration given the media item size
    local suggestedDuration = 0.02 * (mediaItemsSize ^ 2) - 0.6 * mediaItemsSize + 6

    -- if no media event exists, make transitions at suggested duration
    if (isMediaEventsEmpty()) then
        events = defaultEvents
    end

    -- initial item info
    local mediaItemIndex = 1
    local mediaItem = _mediaItemsWithSegments[mediaItemIndex]
    local originalMediaItem = MediaItems[mediaItem.originalIndex]

    if (originalMediaItem:isImage()) then
        mediaItemDuration = suggestedDuration
    else
        mediaItemDuration = math.min(originalMediaItem:getDurationSec(), suggestedDuration)
    end

    -- loop through events
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then goto CONTINUE end
        events = mediaEventToTable(mediaEvent)
        if (#events == 0) then
            events = defaultEvents
        end
        ::CONTINUE::
    end

    local prevTransitionTime = 0
    local didAddClip = false
    local leftBound = mediaItemDuration - _trimThreshold     -- time stamp for left bound of selected media item
    local rightBound = mediaItemDuration + _trimThreshold    -- time stamp for right bound of selected media item
    local candidates = {}   -- table for transition candidates. candidate example: { onset = true, weights = 1.2, diffToSuggestion: 0.24 }

    -- loop through media events
    for i = 1, #events, 1 do
        -- check 'beat' tag in an event and make transition
        local event = events[i]
        if (table.contains(event.tags, "beat")) then
            if (event.startTime >= leftBound and event.startTime <= rightBound) then
                local candidate = {
                    start = event.startTime,
                    onset = table.contains(event.tags, "onset"),
                    weights = event.weight,
                    diffToSuggestion = math.abs(prevTransitionTime + mediaItemDuration - event.startTime)
                }
                table.insert(candidates, candidate)
            end
        end

        -- beat passed right bound
        if (event.startTime > rightBound) then
            local clipDuration = mediaItemDuration
            local bestBeat = pickBestBeat(candidates)
            if bestBeat ~= nil then
                clipDuration = bestBeat.start - prevTransitionTime
            end

            Project:addClip(mediaItem.startTime, clipDuration, 1.0, originalMediaItem)

            if (originalMediaItem:isImage()) then
                addTreatment()
            end

            Treatments:sepiaTreatment(0.0, clipDuration, SEPIA)

            prevTransitionTime = prevTransitionTime + clipDuration

            if shouldAddFadeTransition(mediaItemIndex, mediaItemsSize) then
                Project:addTransition("fade", _transitionDuration)
                prevTransitionTime = prevTransitionTime - _transitionDuration
            end

            didAddClip = true
            candidates = {}
            i = i - 1
        end

        -- update params for next media item
        if (didAddClip) then
            mediaItemIndex = mediaItemIndex + 1

            if (mediaItemIndex > mediaItemsSize) then
                break
            end

            mediaItem = _mediaItemsWithSegments[mediaItemIndex]
            originalMediaItem = MediaItems[mediaItem.originalIndex]

            if (originalMediaItem:isImage()) then
                mediaItemDuration = suggestedDuration
            else
                mediaItemDuration = math.min(originalMediaItem:getDurationSec() - mediaItem.startTime, suggestedDuration)
            end

            leftBound = prevTransitionTime + mediaItemDuration - _trimThreshold
            rightBound = prevTransitionTime + mediaItemDuration + _trimThreshold

            didAddClip = false
        end
    end

    -- handle remaining items
    while (mediaItemIndex <= mediaItemsSize) do
        mediaItem = _mediaItemsWithSegments[mediaItemIndex]
        originalMediaItem = MediaItems[mediaItem.originalIndex]

        if (originalMediaItem:isImage()) then
            mediaItemDuration = suggestedDuration
        else
            mediaItemDuration = math.min(originalMediaItem:getDurationSec() - mediaItem.startTime, suggestedDuration)
        end

        Project:addClip(mediaItem.startTime, mediaItemDuration, 1.0, originalMediaItem)

        if (originalMediaItem:isImage()) then
            addTreatment()
        end

        Treatments:sepiaTreatment(0.0, mediaItemDuration, SEPIA)

        if shouldAddFadeTransition(mediaItemIndex, mediaItemsSize) then
            Project:addTransition("fade", _transitionDuration)
        end

        mediaItemIndex = mediaItemIndex + 1
    end

    Project:addEffect("fadeOut", _fadeOutDuration)
end

main()
