-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

-- effect types
PAN_UP = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.45,
    "ending_x": 0.5,
    "ending_y": 0.55,
    "curve": "LINEAR"
    }
]]
PAN_DOWN = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.55,
    "ending_x": 0.5,
    "ending_y": 0.45,
    "curve": "LINEAR"
    }
]]
PAN_RIGHT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.45,
    "starting_y": 0.5,
    "ending_x": 0.55,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
PAN_LEFT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.55,
    "starting_y": 0.5,
    "ending_x": 0.45,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
ZOOM_IN = [[
    {
      "start_amount": 0.0,
      "end_amount": 0.1,
      "curve": "LINEAR"
    }
  ]];
ZOOM_OUT = [[
    {
      "start_amount": 0.1,
      "end_amount": 0.0,
      "curve": "LINEAR"
    }
  ]];

effects = {
    PAN_UP,
    PAN_DOWN,
    PAN_RIGHT,
    PAN_LEFT,
    ZOOM_IN,
    ZOOM_IN,
    ZOOM_OUT,
    ZOOM_OUT,
}


defaultEvents =
{
  {weight = -0.6564090568257247,startTime = 0.008852317737048754,tags = { "beat", "inferred" }},
  {weight = -0.6562037868633824,startTime = 0.38568478534576145,tags = { "beat", "inferred" }},
  {weight = -0.5675397700801872,startTime = 0.7625172529544741,tags = { "beat", "inferred" }},
  {weight = 1.0814929627361303,startTime = 1.1393497205631868,tags = { "beat", "inferred" }},
  {weight = -0.6318166497175568,startTime = 1.5161821881718995,tags = { "beat", "inferred" }},
  {weight = -0.6367580269059385,startTime = 1.8930146557806122,tags = { "beat", "inferred" }},
  {weight = -0.5405809823521437,startTime = 2.269847123389325,tags = { "beat", "inferred" }},
  {weight = -0.5348457201032594,startTime = 2.6466795909980374,tags = { "beat", "inferred" }},
  {weight = -0.6425212682388022,startTime = 3.0235120586067503,tags = { "beat", "inferred" }},
  {weight = -0.6455194690860987,startTime = 3.4003445262154632,tags = { "beat", "inferred" }},
  {weight = -0.5213160831033892,startTime = 3.7771769938241757,tags = { "beat", "inferred" }},
  {weight = -0.5205384791819655,startTime = 4.154009461432889,tags = { "beat", "inferred" }},
  {weight = -0.6451924750528221,startTime = 4.5308419290416015,tags = { "beat", "inferred" }},
  {weight = -0.35566188402264654,startTime = 4.9076743966503145,tags = { "beat", "inferred" }},
  {weight = -0.6066068422188508,startTime = 5.284506864259026,tags = { "beat", "inferred" }},
  {weight = -0.4928073145102583,startTime = 5.6613393318677385,tags = { "beat", "inferred" }},
  {weight = -0.4931471874803755,startTime = 6.038171799476451,tags = { "beat", "inferred" }},
  {weight = -0.5424384300561079,startTime = 6.415004267085164,tags = { "beat", "inferred" }},
  {weight = 10.5520629442747,startTime = 6.791836734693877,tags = { "beat", "onset" }},
  {weight = 0.30656024361954076,startTime = 7.151746031746032,tags = { "beat", "inferred" }},
  {weight = 3.099376720068937,startTime = 7.511655328798186,tags = { "beat", "onset" }},
  {weight = 4.852660285229163,startTime = 7.836734693877551,tags = { "beat", "onset" }},
  {weight = -0.3436534494752741,startTime = 8.237278911564626,tags = { "beat", "inferred" }},
  {weight = 6.061502092718113,startTime = 8.6378231292517,tags = { "beat", "onset" }},
  {weight = -0.5592492488605268,startTime = 9.01250876108019,tags = { "beat", "inferred" }},
  {weight = -0.6321760365014492,startTime = 9.387194392908677,tags = { "beat", "inferred" }},
  {weight = -0.41043244169696647,startTime = 9.761880024737167,tags = { "beat", "inferred" }},
  {weight = 0.5897035533462128,startTime = 10.136565656565656,tags = { "beat", "inferred" }},
  {weight = -0.5718576898244864,startTime = 10.511251288394146,tags = { "beat", "inferred" }},
  {weight = -0.44041445824056213,startTime = 10.885936920222633,tags = { "beat", "inferred" }},
  {weight = -0.5394969063866901,startTime = 11.260622552051123,tags = { "beat", "inferred" }},
  {weight = 0.8399702166832349,startTime = 11.635308183879612,tags = { "beat", "inferred" }},
  {weight = -0.1621073215301544,startTime = 12.0099938157081,tags = { "beat", "inferred" }},
  {weight = 0.6612638985256648,startTime = 12.38467944753659,tags = { "beat", "inferred" }},
  {weight = 3.5775619998032635,startTime = 12.759365079365079,tags = { "beat", "onset" }},
  {weight = 2.4257255465011207,startTime = 13.084444444444445,tags = { "beat", "onset" }},
  {weight = -0.586240784495969,startTime = 13.459833711262283,tags = { "beat", "inferred" }},
  {weight = -7.434930077010576E-4,startTime = 13.835222978080122,tags = { "beat", "inferred" }},
  {weight = 2.3878789051818514,startTime = 14.210612244897959,tags = { "beat", "onset" }},
  {weight = 0.8242920702071419,startTime = 14.59180650037793,tags = { "beat", "inferred" }},
  {weight = -0.45566214925192655,startTime = 14.973000755857898,tags = { "beat", "inferred" }},
  {weight = -0.45595253428777294,startTime = 15.354195011337868,tags = { "beat", "inferred" }},
  {weight = -0.4835597098817531,startTime = 15.735389266817839,tags = { "beat", "inferred" }},
  {weight = 0.10113729664264366,startTime = 16.11658352229781,tags = { "beat", "inferred" }},
  {weight = 4.018930530808724,startTime = 16.497777777777777,tags = { "beat", "onset" }},
  {weight = 2.7221531245934627,startTime = 16.822857142857142,tags = { "beat", "onset" }},
  {weight = 3.655763879591408,startTime = 17.252426303854875,tags = { "beat", "onset" }},
  {weight = -0.4597546304445937,startTime = 17.647165532879818,tags = { "beat", "inferred" }},
  {weight = 3.012138663204279,startTime = 18.041904761904764,tags = { "beat", "onset" }},
  {weight = 6.0910973713435865,startTime = 18.517913832199547,tags = { "beat", "onset" }},
  {weight = 0.07579720050262907,startTime = 18.889433106575964,tags = { "beat", "inferred" }},
  {weight = 8.95246084940203,startTime = 19.260952380952382,tags = { "beat", "onset" }},
  {weight = 0.7869331791802318,startTime = 19.6324716553288,tags = { "beat", "inferred" }},
  {weight = 3.076398262911783,startTime = 20.003990929705214,tags = { "beat", "onset" }},
  {weight = 2.4398666890915332E-4,startTime = 20.381315192743763,tags = { "beat", "inferred" }},
  {weight = 8.480824465134662,startTime = 20.758639455782312,tags = { "beat", "onset" }},
  {weight = 3.2495620714923836,startTime = 21.13015873015873,tags = { "beat", "onset" }},
  {weight = 4.273730611216909,startTime = 21.51328798185941,tags = { "beat", "onset" }},
  {weight = -0.2111680470196648,startTime = 21.89061224489796,tags = { "beat", "inferred" }},
  {weight = 8.98787324887973,startTime = 22.267936507936508,tags = { "beat", "onset" }},
  {weight = 1.570255514335721,startTime = 22.639455782312925,tags = { "beat", "inferred" }},
  {weight = 2.4014616077314184,startTime = 23.010975056689343,tags = { "beat", "onset" }},
  {weight = 0.5293971197143387,startTime = 23.388299319727892,tags = { "beat", "inferred" }},
  {weight = 13.454159299875398,startTime = 23.76562358276644,tags = { "beat", "onset" }},
  {weight = 9.246630388425842,startTime = 24.13714285714286,tags = { "beat", "onset" }},
  {weight = 2.08026504400248,startTime = 24.52027210884354,tags = { "beat", "onset" }},
  {weight = -0.15147760742705385,startTime = 24.88018140589569,tags = { "beat", "inferred" }},
  {weight = 2.4981685810732257,startTime = 25.240090702947846,tags = { "beat", "onset" }},
  {weight = 3.233895948535497,startTime = 25.623219954648526,tags = { "beat", "onset" }},
  {weight = 3.3778027515130558,startTime = 26.01795918367347,tags = { "beat", "onset" }},
  {weight = 0.3331257852350179,startTime = 26.389478458049886,tags = { "beat", "inferred" }},
  {weight = 11.962743452056143,startTime = 26.760997732426304,tags = { "beat", "onset" }}
}

-- util functions
function table.contains(table, element)
    for _, value in pairs(table) do
      if value == element then
        return true
      end
    end
    return false
end

function table.size(table)
    local ret = 0
    for _, v in pairs(table) do
        ret = ret + 1
    end
    return ret
end

function mediaEventToTable(mediaEvent)
  local numEvents = mediaEvent:size()
  local eventsTable = {}
  for i = 0, numEvents - 1, 1 do
    local start, weights, _, tag = mediaEvent:getEvent(i)
    local event = {
        startTime = start,
        weight = weights,
        tags = tag
    }
    table.insert(eventsTable, event)
  end
  return eventsTable
end

function sortFunc(a, b)
    if a.onset and not b.onset then
        return true
    elseif b.onset and not a.onset then
        return false
    elseif a.weights > b.weights then
        return true
    elseif a.weights < b.weights then
        return false
    elseif a.diffToSuggestion < b.diffToSuggestion then
        return true
    elseif a.diffToSuggestion > b.diffToSuggestion then
        return false
    else
        return false
    end
end

function pickBestBeat(inputCandidates)
    table.sort(inputCandidates, sortFunc)

    for k, v in pairs(inputCandidates) do
        if (k == 1) then
            return v
        end
    end
end

function addTreatment()
    local treatmentStart = 0.0
    local treatmentEnd = 6.0
    local effect = effects[math.random(#(effects))]
    if effect == PAN_UP or effect == PAN_DOWN or effect == PAN_RIGHT or effect == PAN_LEFT then
        Treatments:panTreatment(treatmentStart, treatmentEnd, effect);
    elseif effect == ZOOM_IN or effect == ZOOM_OUT then
        Treatments:zoomTreatment2(treatmentStart, treatmentEnd, effect);
    end
end

function generateMediaItemsWithSegments()
    local mediaItemsCount = table.size(MediaItems)
    local availableSegmentCount = _config.maxItemCount - mediaItemsCount
    local list = {}
    local offset = 0
    for i = 1, mediaItemsCount, 1 do
        local item = MediaItems[i]
        local startTime = item:getStartSec()
        local duration = item:getDurationSec()

        list[i + offset] = {}
        list[i + offset]["originalIndex"] = i
        list[i + offset]["startTime"] =  startTime

        if _config.isVideoSegmentationEnabled and not item:isImage() and duration > _config.minVideoSegmentDuration and availableSegmentCount > 0 then
            local interval = duration / 3
            for j = 1, 2, 1 do
                if availableSegmentCount > 0 then
                    offset = offset + 1
                    availableSegmentCount = availableSegmentCount - 1

                    list[i + offset] = {}
                    list[i + offset]["originalIndex"] = i
                    list[i + offset]["startTime"] = startTime + (interval * j)
                end
            end
        end
    end
    return list
end

function getConfig()
    -- default config
    local config = {
        maxItemCount = 15,
        isVideoSegmentationEnabled = false,
        minVideoSegmentDuration = 30,
        seedValue = 0
    }

    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            for i = 0, mediaEvent:size() - 1, 1 do
                local startTime, weight, duration, tags = mediaEvent:getEvent(i)
                local param = tags[1]
                if param == "maxItemCount" then
                    config.maxItemCount = math.floor(weight)
                elseif param == "isVideoSegmentationEnabled" then
                    config.isVideoSegmentationEnabled = weight == 1.0
                elseif param == "minVideoSegmentDuration" then
                    config.minVideoSegmentDuration = math.floor(weight)
                elseif param == "seed" then
                    config.seedValue = math.floor(weight)
                end
            end
        end
    end

    return config
end

function isMediaEventsEmpty()
    local configFilesAmt = 0
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            configFilesAmt = configFilesAmt + 1
        end
    end
    local resultingTableSize = table.size(MediaEvents) - configFilesAmt
    return resultingTableSize == 0
end

-- const values
_trimThreshold = 1.0
_fadeOutDuration = 0.5
_config = getConfig()
_mediaItemsWithSegments = generateMediaItemsWithSegments()

-- main function
function main()
    -- set seed if necessary
    if _config.seedValue > 0 then
        math.randomseed(_config.seedValue)
    end

    -- media items size
    local mediaItemsSize = table.size(_mediaItemsWithSegments)

    -- calculate minimum clip duration given the media item size
    local suggestedDuration = 0.02 * (mediaItemsSize ^ 2) - 0.6 * mediaItemsSize + 6
    -- if no media event exists, make transitions at suggested duration
    if (isMediaEventsEmpty()) then
        events = defaultEvents
    end

    -- initial item info
    local mediaItemIndex = 1
    local mediaItem = _mediaItemsWithSegments[mediaItemIndex]
    local originalMediaItem = MediaItems[mediaItem.originalIndex]

    if (originalMediaItem:isImage()) then
        mediaItemDuration = suggestedDuration
    else
        mediaItemDuration = math.min(originalMediaItem:getDurationSec(), suggestedDuration)
    end


    -- loop through events
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then goto CONTINUE end
        events = mediaEventToTable(mediaEvent)
        if #events == 0 then
            events = defaultEvents
        end
        ::CONTINUE::
    end
    local numEvents = #events
    local prevTransitionTime = 0
    local didAddClip = false
    local leftBound = mediaItemDuration - _trimThreshold     -- time stamp for left bound of selected media item
    local rightBound = mediaItemDuration + _trimThreshold    -- time stamp for right bound of selected media item
    local candidates = {}   -- table for transition candidates. candidate example: { onset = true, weights = 1.2, diffToSuggestion: 0.24 }

    -- loop through media events
    for i = 1, numEvents, 1 do
        -- check 'beat' tag in an event and make transition
        local event = events[i]
        if (table.contains(event.tags, "beat")) then
            if (event.startTime >= leftBound and event.startTime <= rightBound) then
                local candidate = {
                    start = event.startTime,
                    onset = table.contains(event.tags, "onset"),
                    weights = event.weight,
                    diffToSuggestion = math.abs(prevTransitionTime + mediaItemDuration - event.startTime)
                }
                table.insert(candidates, candidate)
            end
        end

        -- beat passed right bound
        if (event.startTime > rightBound) then
            local clipDuration = mediaItemDuration
            local bestBeat = pickBestBeat(candidates)
            if bestBeat ~= nil then
                clipDuration = bestBeat.start - prevTransitionTime
            end

            Project:addClip(mediaItem.startTime, clipDuration, 1.0, originalMediaItem)

            if (originalMediaItem:isImage()) then
                addTreatment()
            end
            prevTransitionTime = prevTransitionTime + clipDuration
            didAddClip = true
            candidates = {}
            i = i - 1
        end

        -- update params for next media item
        if (didAddClip) then
            mediaItemIndex = mediaItemIndex + 1

            if (mediaItemIndex > mediaItemsSize) then
                break
            end

            mediaItem = _mediaItemsWithSegments[mediaItemIndex]
            originalMediaItem = MediaItems[mediaItem.originalIndex]

            if (originalMediaItem:isImage()) then
                mediaItemDuration = suggestedDuration
            else
                mediaItemDuration = math.min(originalMediaItem:getDurationSec() - mediaItem.startTime, suggestedDuration)
            end

            leftBound = prevTransitionTime + mediaItemDuration - _trimThreshold
            rightBound = prevTransitionTime + mediaItemDuration + _trimThreshold

            didAddClip = false
        end
    end

    -- handle remaining items
    while (mediaItemIndex <= mediaItemsSize) do
        mediaItem = _mediaItemsWithSegments[mediaItemIndex]
        originalMediaItem = MediaItems[mediaItem.originalIndex]

        if (originalMediaItem:isImage()) then
            mediaItemDuration = suggestedDuration
        else
            mediaItemDuration = math.min(originalMediaItem:getDurationSec() - mediaItem.startTime, suggestedDuration)
        end

        Project:addClip(mediaItem.startTime, mediaItemDuration, 1.0, originalMediaItem)

        if (originalMediaItem:isImage()) then
            addTreatment()
        end

        mediaItemIndex = mediaItemIndex + 1
    end

    Project:addEffect("fadeOut", _fadeOutDuration)
end

main()
