-- (c) Meta Platforms, Inc. and affiliates. Confidential and proprietary.

-- effect types
PAN_UP = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.45,
    "ending_x": 0.5,
    "ending_y": 0.55,
    "curve": "LINEAR"
    }
]]
PAN_DOWN = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.5,
    "starting_y": 0.55,
    "ending_x": 0.5,
    "ending_y": 0.45,
    "curve": "LINEAR"
    }
]]
PAN_RIGHT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.45,
    "starting_y": 0.5,
    "ending_x": 0.55,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
PAN_LEFT = [[
    {
    "zoom_scale": 0.1,
    "starting_x": 0.55,
    "starting_y": 0.5,
    "ending_x": 0.45,
    "ending_y": 0.5,
    "curve": "LINEAR"
    }
]]
ZOOM_IN = [[
    {
      "start_amount": 0.0,
      "end_amount": 0.1,
      "curve": "LINEAR"
    }
  ]];
ZOOM_OUT = [[
    {
      "start_amount": 0.1,
      "end_amount": 0.0,
      "curve": "LINEAR"
    }
  ]];

effects = {
    PAN_UP,
    PAN_DOWN,
    PAN_RIGHT,
    PAN_LEFT,
    ZOOM_IN,
    ZOOM_IN,
    ZOOM_OUT,
    ZOOM_OUT,
}

-- util functions
function table.contains(table, element)
    for _, value in pairs(table) do
      if value == element then
        return true
      end
    end
    return false
end

function table.size(table)
    local ret = 0
    for _, v in pairs(table) do
        ret = ret + 1
    end
    return ret
end

function sortFunc(a, b)
    if a.onset and not b.onset then
        return true
    elseif b.onset and not a.onset then
        return false
    elseif a.weights > b.weights then
        return true
    elseif a.weights < b.weights then
        return false
    elseif a.diffToSuggestion < b.diffToSuggestion then
        return true
    elseif a.diffToSuggestion > b.diffToSuggestion then
        return false
    else
        return false
    end
end

function generateProjectWithEmptyBeatEvents(duration)
    for i = 1, table.size(_mediaItemsWithSegments), 1 do
        local mediaItem = MediaItems[_mediaItemsWithSegments[i].originalIndex]
        Project:addClip(0.0, duration, 1.0, mediaItem)
        if (mediaItem:isImage()) then
            addTreatment()
        end
    end
end

function addTreatment()
    local treatmentStart = 0.0
    local treatmentEnd = 6.0
    local effect = effects[math.random(#(effects))]
    if effect == PAN_UP or effect == PAN_DOWN or effect == PAN_RIGHT or effect == PAN_LEFT then
        Treatments:panTreatment(treatmentStart, treatmentEnd, effect);
    elseif effect == ZOOM_IN or effect == ZOOM_OUT then
        Treatments:zoomTreatment(treatmentStart, treatmentEnd, effect);
    end
end

function generateMediaItemsWithSegments()
    local mediaItemsCount = table.size(MediaItems)
    local availableSegmentCount = _config.maxItemCount - mediaItemsCount
    local list = {}
    local offset = 0
    for i = 1, mediaItemsCount, 1 do
        local item = MediaItems[i]
        local startTime = item:getStartSec()
        local duration = item:getDurationSec()

        list[i + offset] = {}
        list[i + offset]["originalIndex"] = i
        list[i + offset]["startTime"] =  startTime

        if _config.isVideoSegmentationEnabled and not item:isImage() and duration > _config.minVideoSegmentDuration and availableSegmentCount > 0 then
            local interval = duration / 3
            for j = 1, 2, 1 do
                if availableSegmentCount > 0 then
                    offset = offset + 1
                    availableSegmentCount = availableSegmentCount - 1

                    list[i + offset] = {}
                    list[i + offset]["originalIndex"] = i
                    list[i + offset]["startTime"] = startTime + (interval * j)
                end
            end
        end
    end
    return list
end

function getConfig()
    -- default config
    local config = {
        maxItemCount = 20,
        isVideoSegmentationEnabled = false,
        minVideoSegmentDuration = 30
    }

    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            for i = 0, mediaEvent:size() - 1, 1 do
                local startTime, weight, duration, tags = mediaEvent:getEvent(i)
                local param = tags[1]
                if param == "maxItemCount" then
                    config.maxItemCount = math.floor(weight)
                elseif param == "isVideoSegmentationEnabled" then
                    config.isVideoSegmentationEnabled = weight == 1.0
                elseif param == "minVideoSegmentDuration" then
                    config.minVideoSegmentDuration = math.floor(weight)
                end
            end
        end
    end

    return config
end

function isMediaEventsEmpty()
    local hasConfig = false
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then
            hasConfig = true
        end
    end

    if hasConfig then
        return table.size(MediaEvents) == 1
    else
        return table.size(MediaEvents) == 0
    end
end

-- const values
_trimThreshold = 1.0
_config = getConfig()
_mediaItemsWithSegments = generateMediaItemsWithSegments()

-- main function
function main()
    -- media items size
    local mediaItemsSize = table.size(_mediaItemsWithSegments)

    -- calculate minimum clip duration given the media item size
    local suggestedDuration = 0.02 * (mediaItemsSize ^ 2) - 0.6 * mediaItemsSize + 6

    -- if no media event exists, make transitions at suggested duration
    if (isMediaEventsEmpty()) then
        generateProjectWithEmptyBeatEvents(suggestedDuration)
        return
    end

    -- initial item info
    local mediaItemIndex = 1
    local mediaItem = _mediaItemsWithSegments[mediaItemIndex]
    local originalMediaItem = MediaItems[mediaItem.originalIndex]

    if (originalMediaItem:isImage()) then
        mediaItemDuration = suggestedDuration
    else
        mediaItemDuration = math.min(originalMediaItem:getDurationSec(), suggestedDuration)
    end

    -- loop through events
    for _, mediaEvent in ipairs(MediaEvents) do
        if mediaEvent:getSourceMedia() == "config" then goto CONTINUE end

        local numEvents = mediaEvent:size()
        local prevTransitionTime = 0
        local didAddClip = false
        local leftBound = mediaItemDuration - _trimThreshold     -- time stamp for left bound of selected media item
        local rightBound = mediaItemDuration + _trimThreshold    -- time stamp for right bound of selected media item
        local candidates = {}   -- table for transition candidates. candidate example: { onset = true, weights = 1.2, diffToSuggestion: 0.24 }

        -- if no media event exists, make transitions at suggested duration
        if (numEvents == 0) then
            generateProjectWithEmptyBeatEvents(suggestedDuration)
            return
        end
        ::CONTINUE::
    end
end

main()
