
-- SQLite does not allow first adding a null column to the table and then altering it to a not null column.
-- The way to add a new not null column is to copy existing data into a temporary table and rename it, as below.
CREATE TABLE new_Events (
    id        TEXT PRIMARY KEY NOT NULL,
    timestamp TEXT NOT NULL,
    sent      INTEGER NOT NULL,
    metadata  TEXT NOT NULL,
    type      TEXT NOT NULL
);

-- All events are set to 'not sent' after the upgrade.
INSERT INTO new_Events SELECT id, timestamp, 0, metadata, type FROM Events;
DROP TABLE Events;
ALTER TABLE new_Events RENAME TO Events;

-- Events sent are no longer tracked in a separate table, instead they are tracked using the 'sent' column in the Events table.
DROP TABLE SentEvents;

-- Set the schema version.
PRAGMA user_version = 2;
