--@input float screenScale = 0.950 {"widget":"slider","min":0.0,"max":1.0}
--@input float shadowRadius = 0.20 {"widget":"slider","min":0.0,"max":1.0}
--@input float shadowoffsetX = 0.0 {"widget":"slider","min":0.0,"max":1.0}
--@input float shadowoffsetY = 0.0 {"widget":"slider","min":0.0,"max":1.0}


--@input float authorx = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float authory = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float userx = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float usery = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float titleInfox = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float titleInfoy = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float iconx = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input float icony = 0.0{"widget":"slider","min":0.0,"max":1.0}
--@input int iType = 1{"widget":"slider","min":1,"max":11.0}

local json = cjson.new()
local exports = exports or {}
local SeekModeScript = SeekModeScript or {}
SeekModeScript.__index = SeekModeScript
function SeekModeScript.new(construct, ...)
    local self = setmetatable({}, SeekModeScript)
    if construct and SeekModeScript.constructor then SeekModeScript.constructor(self, ...) end
    self.startTime = 0.0
    self.endTime = 3.0
    self.curTime = 0.0
    self.width = 0.0
    self.height = 0.0
    -- self.fgw = 1014
    -- self.fgh = 725
    self.bgw = 720
    self.bgh = 1280
    self.scale = 0.3
    self.pos = Amaz.Vector2f(0.0,0.0)
    self.fontFactor = 1.0
    self.init = true
    self.times = 0
    self.trigger = 0
    self.ratioList={
        ["11"]=1.000,
        ["34"]=0.7500,
        ["916"]=0.5625,
        ["919"]=0.4737
    }
    self.curType = 1
    self.pageInfo = {
        iType = 8,
        workShowType = 0,
        maskType = 1
    }
    self.rth = Amaz.BuiltinObject:getOutputTextureHeight()
    self.rtw = Amaz.BuiltinObject:getOutputTextureWidth()
    self.fgw = self.rtw
    self.fgh = self.rth
    return self
end

local test = true
function SeekModeScript:constructor()

end

function SeekModeScript:onUpdate(comp, detalTime)
    self.curTime = self.curTime + detalTime
    self:seek(self.curTime - self.startTime)
end



function SeekModeScript:start(comp)
    self.shadowEntity = comp.entity.scene:findEntityBy("shadowColor")
    self.shadowMaterial = self.shadowEntity:getComponent("MeshRenderer").material

    self.rootEntity = comp.entity.scene:findEntityBy("model")
    self.videoEntity = comp.entity.scene:findEntityBy("videoScreen")
    self.maskEntity = comp.entity.scene:findEntityBy("mask")
    self.videoMaterial = self.videoEntity:getComponent("MeshRenderer").material
    self.WhiteBackEntity = comp.entity.scene:findEntityBy("whiteBack")
    self.WhiteMaterial = self.WhiteBackEntity:getComponent("MeshRenderer").material
    self.maskMaterial = self.maskEntity:getComponent("MeshRenderer").material
    self.iconEntity = comp.entity.scene:findEntityBy("icon")
    self.comp = comp
end

local UTF8 = {
    codec = cjson.new(),
    tag = "jorgen",
}
---@param headByte number
---@return number
function UTF8.ucs4CharSize (headByte)
    if headByte < 128 then
        return 1
    elseif headByte < 192 then
        return nil
    elseif headByte < 224 then
        return 2
    elseif headByte < 240 then
        return 3
    elseif headByte < 248 then
        return 4
    elseif headByte < 252 then
        return 5
    else
        return 6
    end
end

function SeekModeScript:onEvent(sys, event)

end
function SeekModeScript:strOmit(str,chars,rowth)
    local count = chars:size()
    local newStr = str
    if(count >= 2) then
        local j = count-1
        if(chars:get(j).rowth > rowth) then
            local bytes = 0
            local start = false
            local times = 0 
            for i = count-1,0,-1 do
                local char = chars:get(i)
                if(char.rowth == rowth) then
                    start = true
                end
                if(start == true) then
                    if(times == 0) then
                        if(bytes< 2) then
                            bytes= bytes + UTF8.ucs4CharSize(string.byte(char.utf8code, 1))
                        else
                            times = 1
                            bytes = UTF8.ucs4CharSize(string.byte(char.utf8code, 1))
                        end
                    else 
                        bytes= bytes + UTF8.ucs4CharSize(string.byte(char.utf8code, 1))
                    end
                end
            end
            newStr = string.sub(str,1,bytes).."..."
        end
    else
        newStr = ""
    end
    return newStr
end

function SeekModeScript:showOldType(is_old_type)
    self.namelist = {"Camera", "Camera_shadow1", "Camera_shadow2", "blurX","blurY","shadow","shadowColor"}
    for key, value in pairs(self.namelist) do
        local entity = self.comp.entity.scene:findEntityBy(value)
        entity.visible = not is_old_type
    end 
end

function SeekModeScript:showTypeI()  
    local w = self.bgw
    local h = self.bgh
    local k = 9*self.fgh/(16*self.fgw)
    local k1 = self.bgw*self.fgh/(self.fgw*self.bgh)
    --local k1 = self.rtw*self.fgh/(self.fgw*self.rth)
    local rf = 2.0
    -- local w = Amaz.BuiltinObject:getInputTextureWidth()
    -- local h = Amaz.BuiltinObject:getInputTextureHeight()
    -- local w = 1080
    -- local h = 1920
    -- Amaz.LOGI("TestTag1","w: "..w.." , h: "..h)
    local scale1 = 1
    Amaz.LOGE("liuchangSize",self.fgh..","..self.fgw..self.bgh..","..self.bgw)
    self.WhiteBackEntity.visible = false
    self.shadowEntity:getComponent("Transform").localScale = Amaz.Vector3f(1.02*scale1,scale1*k1+0.01*w/h, 1.0)*self.scale
    self.shadowMaterial:setFloat("screenScaleX",1.0)
    self.shadowMaterial:setFloat("scaleY",k1)
    self.shadowMaterial:setFloat("iRadius",0.1*rf)
    self.videoEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,scale1*k1,scale1)
    self.videoMaterial:setFloat("iShowWhite",0.0)
    self.videoMaterial:setFloat("iRadius",0.1*rf)
    self.videoMaterial:setFloat("scaleY",k1)
    self.videoMaterial:setFloat("u_aspect",self.fgh/self.fgw)
    local screenSizes = Amaz.Vector2f(self.fgw, self.fgh)
    self.videoMaterial:setVec2("screenSize",screenSizes)
    self.videoEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0);
    self.shadowEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0);
    if(self.pageInfo.maskType ~= nil) then
        if(self.pageInfo.maskType == 1) then
            self.maskEntity.visible = true
            self.maskEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,-scale1*k,scale1)
            self.maskMaterial:setFloat("iShowWhite",0.0)
            self.maskMaterial:setFloat("iRadius",0.1*rf/k)
            self.maskMaterial:setFloat("scaleY",k1)
            self.maskMaterial:setFloat("u_aspect",self.fgh/self.fgw)
            self.maskMaterial:setFloat("u_bounding",1.0-62.0/489.0/k)
        end
    end
    if(self.pageInfo.workShowType ~= nil and self.pageInfo.workShowType == 1) then
        local iconx = self.props:find("iconx")
        local icony = self.props:find("icony")
        self.iconEntity.visible = true
        self.iconEntity:getComponent("Transform").localPosition.x = scale1*w/h*(w-60)/w-iconx
        self.iconEntity:getComponent("Transform").localPosition.y = (scale1*(h*k-60)/h)-icony
    end
end

function SeekModeScript:setUserInfo()
end

function SeekModeScript:showTypeIV() 

    local w = self.bgw
    local h = self.bgh
    local k = 9*self.fgh/(16*self.fgw)
    local k1 = self.bgw*self.fgh/(self.fgw*self.bgh)
    --local k1 = self.rtw*self.fgh/(self.fgw*self.rth)
    -- local w = Amaz.BuiltinObject:getInputTextureWidth()
    -- local h = Amaz.BuiltinObject:getInputTextureHeight()
    -- local w = 1080
    -- local h = 1920
    -- Amaz.LOGI("TestTag1","w: "..w.." , h: "..h)
    local scale1 = 1
    

    self.WhiteBackEntity.visible = false
    self.videoEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,scale1*k1, scale1)
    self.videoEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0)
    self.videoMaterial:setFloat("iShowWhite",2.0)
    self.videoMaterial:setFloat("u_aspect",self.fgh/self.fgw)
    if(self.pageInfo.maskType ~= nil) then
        if(self.pageInfo.maskType == 1) then
            self.maskEntity.visible =true
            self.maskEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,-scale1*k1,scale1)
            self.maskMaterial:setFloat("iShowWhite",2.0)
            self.maskMaterial:setFloat("u_aspect",self.fgh/self.fgw)
            self.maskMaterial:setFloat("u_bounding",1.0-62.0/489.0/k)
        end
    end

    if(self.pageInfo.workShowType ~= nil and self.pageInfo.workShowType == 1) then
        local iconx = self.props:find("iconx")
        local icony = self.props:find("icony")
        self.iconEntity.visible = true
        self.iconEntity:getComponent("Transform").localPosition.x = scale1*w/h*(w-60)/w-iconx
        self.iconEntity:getComponent("Transform").localPosition.y = (scale1*(h*k-60)/h)-icony
    end
end


function SeekModeScript:showTypeVII() 


    local w = self.bgw
    local h = self.bgh
    -- local w = 1014
    -- local h = 725
    local k = 9*self.fgh/(16*self.fgw)
    local k1 = self.bgw*self.fgh/(self.fgw*self.bgh)
    --local k1 = self.rtw*self.fgh/(self.fgw*self.rth)
    -- local w = 1080
    -- local h = 1920
    -- Amaz.LOGI("TestTag1","w: "..w.." , h: "..h)
    local scale = self.props:find("screenScale")
    

    self.WhiteBackEntity.visible = true
    local scale1 = 1
    local whiteScale = 1.02
    self.WhiteBackEntity:getComponent("Transform").localScale = Amaz.Vector3f(whiteScale,k1+0.02*w/h, 1.0)
    self.videoEntity:getComponent("Transform").localScale = Amaz.Vector3f(1.0,k, 1.0)
    self.videoMaterial:setFloat("iShowWhite",2.0)
    self.WhiteMaterial:setFloat("iShowWhite",2.0)
    self.videoMaterial:setFloat("u_aspect",self.fgh/self.fgw)
    self.WhiteMaterial:setFloat("u_aspect",self.fgh/self.fgw)

    --self.WhiteBackEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,rect.height/h, 0.0)
    --self.videoEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,rect.height/h, 0.0);
    self.WhiteBackEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0)
    self.videoEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0)
    if(self.pageInfo.workShowType ~= nil and self.pageInfo.workShowType == 1) then
        local iconx = self.props:find("iconx")
        local icony = self.props:find("icony")
        self.iconEntity.visible = true
        self.iconEntity:getComponent("Transform").localPosition.x = scale1*w/h*(w-60)/w-iconx
        self.iconEntity:getComponent("Transform").localPosition.y = (scale1*(h*k1-60)/h)-icony
    end
end

function SeekModeScript:showTypeVIII() 
    local w = self.bgw
    local h = self.bgh
    local k = 9*self.fgh/(16*self.fgw)
    local k1 = self.bgw*self.fgh/(self.fgw*self.bgh)
    --local k1 = self.rtw*self.fgh/(self.fgw*self.rth)
    local rf = 0.4
    -- local w = Amaz.BuiltinObject:getInputTextureWidth()
    -- local h = Amaz.BuiltinObject:getInputTextureHeight()
    -- local w = 1080
    -- local h = 1920
    -- Amaz.LOGI("TestTag1","w: "..w.." , h: "..h)
    local scale1 = 1
    --self.rootEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale,scale, scale)
    
    self.WhiteBackEntity.visible = false
    self.videoEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,scale1*k1,scale1)
    self.videoMaterial:setFloat("iShowWhite",0.0)
    self.videoMaterial:setFloat("iRadius",0.1*rf/k)
    self.videoMaterial:setFloat("scaleY",scale1*k1)
    self.videoMaterial:setFloat("u_aspect",self.fgh/self.fgw)
    self.videoEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0)
    if(self.pageInfo.maskType ~= nil) then 
       if(self.pageInfo.maskType == 1) then
            self.maskEntity.visible = true
            self.maskEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,-scale1*k,scale1) 
            self.maskMaterial:setFloat("iShowWhite",0.0)
            self.maskMaterial:setFloat("iRadius",0.1*rf/k)
            self.maskMaterial:setFloat("scaleY",scale1*k1)
            self.maskMaterial:setFloat("u_aspect",self.fgh/self.fgw)
            self.maskMaterial:setFloat("u_bounding",1.0-62.0/489.0/k)
       end
    end
    if(self.pageInfo.workShowType ~= nil and self.pageInfo.workShowType == 1) then
        local iconx = self.props:find("iconx")
        local icony = self.props:find("icony")
        self.iconEntity.visible = true
        self.iconEntity:getComponent("Transform").localPosition.x = scale1*w/h*(w-60)/w-iconx
        self.iconEntity:getComponent("Transform").localPosition.y = (scale1*(h*k-60)/h)-icony
    end
end


function SeekModeScript:showTypeIX() 
    local w = self.bgw
    local h = self.bgh
    local k = 9*self.fgh/(16*self.fgw)
    local k1 = self.bgw*self.fgh/(self.fgw*self.bgh)
    --local k1 = self.rtw*self.fgh/(self.fgw*self.rth)
    -- local w = Amaz.BuiltinObject:getInputTextureWidth()
    -- local h = Amaz.BuiltinObject:getInputTextureHeight()
    -- local w = 1080
    -- local h = 1920
    -- Amaz.LOGI("TestTag1","w: "..w.." , h: "..h)
    --local scale1 = self.props:find("screenScale")
    local scale1 = 1
    

    self.WhiteBackEntity.visible = false

    local scaley =  scale1;
    self.shadowEntity:getComponent("Transform").localScale = Amaz.Vector3f(1.02*scale1,scale1*k1+0.01*w/h, 1.0)*self.scale
    self.shadowMaterial:setFloat("screenScaleX",1.0)
    self.shadowMaterial:setFloat("scaleY",scale1*k1)
    self.videoEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,scale1*k,scale1)
    self.videoMaterial:setFloat("iShowWhite",2.0)
    self.WhiteMaterial:setFloat("iShowWhite",2.0)
    self.videoMaterial:setFloat("u_aspect",self.fgh/self.fgw)
    self.WhiteMaterial:setFloat("u_aspect",self.fgh/self.fgw)
    self.videoEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0)
    self.shadowEntity:getComponent("Transform").localPosition = Amaz.Vector3f(0.0,0.0, 0.0)
    if(self.pageInfo.maskType ~= nil) then
        if(self.pageInfo.maskType == 1) then
            self.maskEntity.visible = true
            self.maskEntity:getComponent("Transform").localScale = Amaz.Vector3f(scale1,-scale1*k1,scale1)
            self.maskMaterial:setFloat("iShowWhite",2.0)
            self.maskMaterial:setFloat("u_aspect",self.fgh/self.fgw)
            self.maskMaterial:setFloat("u_bounding",1.0-62.0/489.0*k)
        end
    end
    if(self.pageInfo.workShowType ~= nil and self.pageInfo.workShowType == 1) then
        local iconx = self.props:find("iconx")
        local icony = self.props:find("icony")
        self.iconEntity.visible = true
        self.iconEntity:getComponent("Transform").localPosition.x = scale1*w/h*(w-60)/w-iconx
        self.iconEntity:getComponent("Transform").localPosition.y = (scale1*(h*k1-60)/h)-icony
    end
end

function SeekModeScript:updateScreenStyle()
    local w = Amaz.BuiltinObject:getInputTextureWidth()
    local h = Amaz.BuiltinObject:getInputTextureHeight()
    local curType = self.refreshState  and self.pageInfo.iType or  self.props:find("iType")
    self:showOldType(false)
    --local scale = self.props:find("screenScale")
    self.iconEntity.visible = false
    self.maskEntity.visible = false
    --[[if(self.init == false and self.times == 0) then
        self.AuthorText.fontSize = self.AuthorText.fontSize*self.fontFactor
        self.init = true
        self.times = 1
    end]]

    if curType == 1 then 
        self:showOldType(true)
    elseif curType == 2 then 
        self:showOldType(true)
        self:showTypeVII()
    elseif curType == 3 then 
        self:showOldType(true)
    elseif curType == 4 then 
        self:showOldType(true)
        self:showTypeIV()
    elseif curType == 5 then 
        self:showOldType(true)
    elseif curType == 6 then 
        self:showTypeIX()   
    elseif curType == 7 then  
    elseif curType == 8 then 
        self:showOldType(true)
        self:showTypeVIII()
    elseif curType == 9 then 
    elseif curType == 10 then
        self:showOldType(true) 
        self:showTypeI()
    elseif curType == 11 then
        self:showOldType(true)
    end
    local scale = self.scale
    self.rootEntity:getComponent("Transform").localScale = Amaz.Vector3f(self.scale,self.scale,self.scale)
    self.rootEntity:getComponent("Transform"):setWorldPosition(Amaz.Vector3f(self.pos.x*self.bgw/self.bgh,self.pos.y,0.0))
    self.shadowEntity:getComponent("Transform"):setWorldPosition(Amaz.Vector3f(self.pos.x,self.pos.y,0.0))
end

function SeekModeScript:onStart(comp)
    self.comp = comp
    self.duration = 3.0
    self.params = {}
    self.anims = {}
    self.animDirty = true
    self.scene = comp.entity.scene
    self.trans = comp.entity:getComponent("Transform")
    self.localEulerX = 0.0
    self.localEulerY = 0.0
    self.localEulerZ = 0.0
    self.screenRatio = 1000/466.0
    -- self.screenMaterial = self.scene:findEntityBy("sub1"):getComponent("MeshRenderer").material
    self.videoMat = self.scene:findEntityBy("video"):getComponent("MeshRenderer").material
    self.fxaaMat = self.scene:findEntityBy("fxaa"):getComponent("MeshRenderer").material
    self.blendMat = self.scene:findEntityBy("blend"):getComponent("MeshRenderer").material
end

function SeekModeScript:seek(time)

    self.props = self.comp.properties
    if self.first == nil then
        self.first = true
        self:start(self.comp)
    end
    self:updateScreenStyle()
    local w = Amaz.BuiltinObject:getInputTextureWidth()
    local h = Amaz.BuiltinObject:getInputTextureHeight()
    if w ~= self.width or h ~= self.height or test then
        self.width = w
        self.height = h

        local min = 100000.0
        local currentRatio = w/h
        local currentRatiostr = "11"
        for k,v in pairs(self.ratioList) do
            local result = math.abs(currentRatio - v)
            if(result < min) then
                min = result
                currentRatiostr = k
            end
        end

        -- local pos = self.localTransAll_table:get(currentRatiostr.."pos")
        -- self.localTransAll_transform.localPosition.x = pos.x
        -- self.localTransAll_transform.localPosition.y = pos.y
        -- self.localTransAll_transform.localPosition.z = pos.z
        -- local scale = self.localTransAll_table:get(currentRatiostr.."scale")
        -- self.localTransAll_transform.localScale = Amaz.Vector3f(scale,scale*h/w,1)
    end
end

function SeekModeScript:setDuration(duration)
    self.duration = duration
    self.animDirty = true
end


function SeekModeScript:clear()
    self.anims = {}
    self.params = {}
    self.animDirty = true
    self.localEulerX = 0.0
    self.localEulerY = 0.0
    self.localEulerZ = 0.0
end

function SeekModeScript:setParams(name, value)
    if name == "u_size" then
        -- Amaz.LOGI("TestTag","enter:u_size")
        self.videoMat:setVec4("u_size", value)
        self.bgw = value.x
        self.bgh = value.y
        self.fgw = value.z
        self.fgh = value.w
        local bgAspect = value.x / value.y
        local videoAspect = value.z / value.w
        if bgAspect > videoAspect then
            self.scaleCorrect = value.w / value.y
        else
            self.scaleCorrect = value.z / value.x
        end
        --self.screenMaterial:setVec4("u_size", value)
        --self.scaleCorrect = value.z / value.x
        local FBS = Amaz.Vector2f(value.x, value.y)
        self.fxaaMat:setVec2("FBS", FBS)
        self.videoMaterial:setVec4("u_size", value)
        self.init = false
        Amaz.LOGI("TestTag11",value.x..","..value.y..","..value.z..","..value.w)
    elseif name == "u_pos" then
        --self.videoMaterial:setVec2("u_pos", value)
        --self.blendMat:setVec2("u_pos", value)
        self.pos = value
        Amaz.LOGE("liuchangPos",self.pos.x..","..self.pos.y)
        --self.rootEntity:getComponent("Transform").localPosition = Amaz.Vector3f(value.x,value.y,.0)
    elseif name == "u_angle" then
        --self.videoMaterial:setFloat("u_angle", value)
        self.blendMat:setFloat("u_angle", value)
    elseif name == "u_scale" then
        --self.videoMaterial:setFloat("u_scale", value*self.scaleCorrect)
        --self.blendMat:setFloat("u_scale", value*self.scaleCorrect)
        self.scale = value*self.scaleCorrect
        Amaz.LOGE("liuchangScale",self.scale)
        --self.scale = 0.8
    elseif name == "u_flipX" then
        self.videoMaterial:setFloat("u_flipX", value)
    elseif name == "u_flipY" then
        self.videoMaterial:setFloat("u_flipY", value)
    elseif name == "_alpha" then
        self.blendMat:setFloat("_alpha", value)
    elseif name == "3DParams" then
        self.refreshState = true
        local pageInfo = json.decode(value)
        self.pageInfo = pageInfo
    end
end



exports.SeekModeScript = SeekModeScript
return exports
