precision highp float;

varying vec2 fTexCoord;
uniform sampler2D _MainTex;
uniform vec4 u_ScreenParams;
uniform  float iRatio;
uniform  float iRadius;
uniform vec4 shadowColor;

float boxRound(vec2 uv, float r)
{
    float ratio = iRatio*u_ScreenParams.x/u_ScreenParams.y;
    vec2 p = abs((uv - 0.5) * 2.0);
    vec2 q = vec2(p.x * ratio, p.y);
    
    vec2 circle_center = vec2(ratio - r, 1.0 - r);
    
    vec2 d = q - circle_center;

    float smoothRadius = 0.002;
    return step(0.001, max(min(d.x, d.y), 0.0)) * smoothstep(0.0, smoothRadius, length(d)-r);
}

void main() 
{
    vec4 color = texture2D(_MainTex, fTexCoord);
    vec4 colorVoid = vec4(0.0);
    gl_FragColor = mix(color, colorVoid, boxRound(fTexCoord, iRadius));

    // gl_FragColor = color;
}
