precision highp float;

attribute vec3 attPosition;
attribute vec2 attUV;

uniform mat4 u_MVP;
uniform mat4 u_Model;
uniform vec2 u_pos;
uniform float u_scale;
uniform float u_angle;
uniform vec4 u_size;
uniform float u_aspect;
varying vec2 uv1;
void main()
{
    float cosTheta = cos(u_angle);
    float sinTheta = sin(u_angle);
    float aspect = u_size.x / u_size.y;
    vec2 pos = attPosition.xy;
    pos = vec2(pos.x * u_scale, pos.y * u_scale);
    pos = vec2(pos.x * u_aspect, pos.y);
    pos = vec2(cosTheta * pos.x + sinTheta * pos.y, cosTheta * pos.y - sinTheta * pos.x);
    pos = vec2(pos.x / u_aspect, pos.y);
    pos = vec2(pos.x + u_pos.x, pos.y + u_pos.y);
    gl_Position = u_MVP*vec4(pos.xy, 0.0, 1.0);
    vec2 uv = vec2(pos.x * 0.5 + 0.5, pos.y * 0.5 + 0.5);
    uv1 = (attUV+vec2(-0.5,-0.5))*vec2(u_aspect,1.0)+vec2(0.5,0.5);
}
