precision highp float;

varying vec2 uv1;
uniform sampler2D _MainTex;
uniform vec4 u_ScreenParams;
uniform  float iRatio;
uniform  float iRadius;
uniform vec4 shadowColor;
uniform float iShowWhite;
uniform vec2 screenSize;
uniform float scaleY;
float boxRound1(vec2 centerPos,vec2 uv,float r,vec2 boxSize,vec2 imageSize){
    uv -= centerPos;
    uv *= imageSize/boxSize;
    uv += centerPos;
    float radius = r/boxSize.x;
    float k = boxSize.x/boxSize.y;
    vec2 scale = vec2(1.0,k);
    vec2 r1 = vec2(1.0,k)*radius;
    vec2 uv1 = abs(uv-vec2(0.5))-vec2(0.5)+r1;
    float d = length(max(uv1/scale,0.0))-radius + 0.5;
    //float delta = 0.06/r;
    float delta = 0.004;
    return smoothstep(0.5-delta,0.5+delta,d);
}
float boxRound(vec2 uv, float r)
{
    float ratio = iRatio*u_ScreenParams.x/u_ScreenParams.y*1.0;
    vec2 p = abs((uv - 0.5) * 2.0);
    vec2 q = vec2(p.x * ratio, p.y);
    
    vec2 circle_center = vec2(ratio - r, 1.0 - r/scaleY);
    
    vec2 d = q - circle_center;
    d.y *= scaleY;
    float smoothRadius = 0.001;
    float state = step(0.01,iShowWhite)*step(0.5,uv.y) + step(iShowWhite,0.01);
    return state*step(0.001, max(min(d.x, d.y), 0.0)) * smoothstep(r-0.004,r + 0.004 , length(d));
}
float inBox(vec2 uv){
    return (step(0.0,uv.x)-step(1.0,uv.x))*(step(0.0,uv.y)-step(1.0,uv.y));
}
float inBox1(vec2 uv, vec2 boxsize){
    uv *= boxsize;
    return (step(2.0, uv.x)-step(boxsize.x - 2.0, uv.x)*(step(2.0, uv.y) - step(boxsize.y - 2.0, uv.y)));
}
void main() 
{

    vec4 color = texture2D(_MainTex, uv1);
    vec4 colorVoid = vec4(0.0);
    vec2 uv = uv1;
    uv -= 0.5;
    uv /= vec2(1.0-3.0/122.0 * (screenSize.y / screenSize.x) * (screenSize.x * 1.33 / screenSize.y),1.0-3.0/122.0 * (screenSize.x * 1.33 / screenSize.y));
    //uv /= vec2(1.0-3.3/122.0*(screenSize.y/screenSize.x),1.0-3.3/122.0);
    uv += 0.5;
//    vec2 uv2 = uv1;
//    uv2 -= 0.5;
//    //uv /= vec2(1.0-3.3/122.0 * (screenSize.y / screenSize.x) * (1440.0 / screenSize.y),1.0-3.3/122.0 * (1440.0 / screenSize.y));
//    uv2 /= vec2(1.0-3.3/122.0*(screenSize.x/screenSize.y),1.0-3.3/122.0);
//    uv2 += 0.5;
    
    // if(uv1.x<0.0 ||uv1.x>1.0||uv1.y<0.0||uv1.y>1.0){
    //     gl_FragColor = vec4(0.0);
    //     return;
    // }
    vec4 finColor = colorVoid;
    vec4 color1 = colorVoid;
    if(inBox(uv1)>0.5){
        //finColor = vec4(inBox(uv1)*(1.0-boxRound(uv1, iRadius))-inBox(uv)*(1.0-boxRound(uv, iRadius)));
        //vec4 color1 = mix(color,vec4(0.0, 0.0, 0.0, 1.0),inBox(uv1)*(1.0-boxRound(uv1, iRadius))-inBox(uv)*(1.0-boxRound(uv, iRadius)));
        //color1 = mix(color,vec4(0.0, 0.0, 0.0, 1.0),inBox(uv1)*(1.0-boxRound1(vec2(0.5),uv1,108.0,newVideosize,newVideosize))-inBox(uv)*(1.0-boxRound1(vec2(0.5),uv,108.0*0.926,newVideosize,newVideosize)));
        //color1 =mix(color,vec4(0.0, 0.0, 0.0, 1.0), inBox(uv1)*0.5 - inBox(uv)*0.5);
        float r = screenSize.x / 8.0;
        color1 = mix(color,vec4(0.0, 0.0, 0.0, 1.0),(1.0-boxRound1(vec2(0.5),uv1,r,screenSize,screenSize))-(1.0-boxRound1(vec2(0.5),uv,r*0.91,screenSize,screenSize)));
        finColor = mix(color1, colorVoid,boxRound1(vec2(0.5),uv1,r,screenSize,screenSize));
        //gl_FragColor = vec4(vv, 0.0, 0.0, 1.0)
        //finColor = color1;
    }
    gl_FragColor = finColor;
    //gl_FragColor = vec4(screenSize.y / 1280.0,0,0,1.0);
    // // gl_FragColor = color;
}
