precision highp float;

varying vec2 uv1;
uniform sampler2D _MainTex;
uniform vec4 u_ScreenParams;
uniform  float iRatio;
uniform  float iRadius;
uniform vec4 shadowColor;
uniform float iShowWhite;
uniform float u_bounding;
uniform float scaleY;
float boxRound(vec2 uv, float r)
{
    float ratio = iRatio*u_ScreenParams.x/u_ScreenParams.y;
    vec2 p = abs((uv - 0.5) * 2.0);
    vec2 q = vec2(p.x * ratio, p.y);
    
    vec2 circle_center = vec2(ratio - r, 1.0 - r/scaleY);
    
    vec2 d = q - circle_center;
    d.y *= scaleY;
    float smoothRadius = 0.0005;
    float state = step(0.01,iShowWhite)*step(0.5,uv.y) + step(iShowWhite,0.01);
    return state*step(0.001, max(min(d.x, d.y), 0.0)) * smoothstep(r - 0.002,r + 0.002 , length(d));
}

void main() 
{
    if(uv1.x<0.0 ||uv1.x>1.0){
        gl_FragColor = vec4(0.0);
        return;
    }
    if(uv1.y<=u_bounding) {
        gl_FragColor = vec4(0.0);
        return;
    }
    vec4 color = texture2D(_MainTex, uv1);
    vec4 colorVoid = vec4(0.0);
    vec4 finColor = mix(color, colorVoid, (1.0-step(1.2,iShowWhite))*boxRound(uv1, iRadius));
    //gl_FragColor = vec4(1.0,0.6,0.3,0.3*finColor.a*(uv1.y-u_bounding)/(1.0-u_bounding));
    //gl_FragColor = finColor;
    gl_FragColor = vec4(finColor.rgb,0.3*finColor.a*(uv1.y-u_bounding)/(1.0-u_bounding));
    //gl_FragColor = vec4(1.0,0.6,0.3,1.0);
    // gl_FragColor = color;
}
