precision highp float;

varying vec2 uv;
uniform sampler2D inputImageTexture;
uniform int inputWidth;
uniform int inputHeight;
uniform float blurSize;
uniform vec4 shadowColor;
uniform float scaleSize;
uniform vec4 u_ScreenParams;
uniform  float iRatio;
uniform  float iRadius;
uniform float ishadowRadius;
uniform float screenScaleX;
uniform float screenScaleY;
uniform float scaleY;
#define textureCoordinate uv


float boxRound(vec2 uv, float r)
{
    float ratio = iRatio*u_ScreenParams.x/u_ScreenParams.y;
    vec2 p = abs((uv - 0.5) * 2.0);
    vec2 q = vec2(p.x * ratio, p.y);
    
    vec2 circle_center = vec2(ratio - r, 1.0 - r/scaleY);
    
    vec2 d = q - circle_center;
    d.y *= scaleY;
    float smoothRadius = 0.002;
    float result = step(0.001, max(min(d.x, d.y), 0.0)) * smoothstep(0.0, smoothRadius, length(d)-r);

    float disT = min(length(vec2(q.x,q.x)),length(vec2(q.y,q.y)));
    return result + (1.0 - step(uv.x,1.0)) + (1.0 - step(0.0,uv.x))+(1.0 - step(uv.y,1.0)) + (1.0 - step(0.0,uv.y))  ;
}


vec4 erf(vec4 x) {
   vec4 s = sign(x), a = abs(x);
   x = 1.0 + (0.278393 + (0.230389 + 0.078108 * (a * a)) * a) * a;
   x *= x;
   return s - s / (x * x);
}

// Return the mask for the shadow of a box from lower to upper
float boxShadow(vec2 lower, vec2 upper, vec2 point, float sigma) {
  vec4 query = vec4(point - lower, point - upper);
  vec4 integral = 0.5 + 0.5 * erf(query * (sqrt(0.5) / sigma));
  return (integral.z - integral.x) * (integral.w - integral.y);
} 


void main()
{

    vec2 p = abs((uv - 0.5) * 2.0);

    float dis = 1.0 - scaleSize;
    vec2 uvT = (uv - 0.5);
    uvT.x/=scaleSize;
    float scaley1 = 1.0 - (1.0-scaleSize)*u_ScreenParams.x/(u_ScreenParams.y);
    uvT.y/=scaley1;

    // uvT*=0.9;
    uvT = uvT + 0.5;
    vec4 colorVoid = vec4(0.0);
    vec4 col = mix(shadowColor, colorVoid, boxRound(uvT, iRadius/scaleSize));
    gl_FragColor = col;
    // vec4 backColor = shadowColor;

    // float scaleT = scaleSize;

    // float scaley = 1.0-(1.0-scaleT)*u_ScreenParams.x/u_ScreenParams.y;

    // vec4 rect = vec4(u_ScreenParams.x*(1.0-scaleT),u_ScreenParams.y*(1.0-scaley), u_ScreenParams.x*scaleT, u_ScreenParams.y*scaley);
    // float mask = boxShadow(rect.xy, rect.zw, uv * u_ScreenParams.xy,ishadowRadius*10.0);
    // gl_FragColor =mask * gl_FragColor;
    
    //gl_FragColor.a = 1.0;
    // gl_FragColor = mix(shadowColor,vec4(0.0),step(scaleSize,abs(uv1.y))+step(scaleSize,abs(uv1.x)));
}
